/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.indices.segments.IndexSegment;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SegmentsResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SegmentsResponse> {
    @Nonnull
    private final Map<String, IndexSegment> indices;
    @Nonnull
    private final ShardStatistics shards;
    public static final JsonpDeserializer<SegmentsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentsResponse::setupSegmentsResponseDeserializer);

    private SegmentsResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static SegmentsResponse of(Function<Builder, ObjectBuilder<SegmentsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, IndexSegment> indices() {
        return this.indices;
    }

    @Nonnull
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, IndexSegment> item0 : this.indices.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSegmentsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexSegment._DESERIALIZER), "indices");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.indices.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsResponse other = (SegmentsResponse)o;
        return this.indices.equals(other.indices) && this.shards.equals(other.shards);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SegmentsResponse> {
        private Map<String, IndexSegment> indices;
        private ShardStatistics shards;

        public Builder() {
        }

        private Builder(SegmentsResponse o) {
            this.indices = Builder._mapCopy(o.indices);
            this.shards = o.shards;
        }

        private Builder(Builder o) {
            this.indices = Builder._mapCopy(o.indices);
            this.shards = o.shards;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indices(Map<String, IndexSegment> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, IndexSegment value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, Function<IndexSegment.Builder, ObjectBuilder<IndexSegment>> fn) {
            return this.indices(key, fn.apply(new IndexSegment.Builder()).build());
        }

        @Nonnull
        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        @Nonnull
        public SegmentsResponse build() {
            this._checkSingleUse();
            return new SegmentsResponse(this);
        }
    }
}

