/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.ZeroTermsQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MatchPhrasePrefixQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, MatchPhrasePrefixQuery> {
    @Nullable
    private final String analyzer;
    @Nonnull
    private final String field;
    @Nullable
    private final Integer maxExpansions;
    @Nonnull
    private final String query;
    @Nullable
    private final Integer slop;
    @Nullable
    private final ZeroTermsQuery zeroTermsQuery;
    public static final JsonpDeserializer<MatchPhrasePrefixQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchPhrasePrefixQuery::setupMatchPhrasePrefixQueryDeserializer);

    private MatchPhrasePrefixQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.maxExpansions = builder.maxExpansions;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.slop = builder.slop;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public static MatchPhrasePrefixQuery of(Function<Builder, ObjectBuilder<MatchPhrasePrefixQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.MatchPhrasePrefix;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer maxExpansions() {
        return this.maxExpansions;
    }

    @Nonnull
    public final String query() {
        return this.query;
    }

    @Nullable
    public final Integer slop() {
        return this.slop;
    }

    @Nullable
    public final ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.maxExpansions != null) {
            generator.writeKey("max_expansions");
            generator.write(this.maxExpansions.intValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop.intValue());
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMatchPhrasePrefixQueryDeserializer(ObjectDeserializer<Builder> op) {
        MatchPhrasePrefixQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::maxExpansions, JsonpDeserializer.integerDeserializer(), "max_expansions");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop");
        op.add(Builder::zeroTermsQuery, ZeroTermsQuery._DESERIALIZER, "zero_terms_query");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("query");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.maxExpansions);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.slop);
        result = 31 * result + Objects.hashCode(this.zeroTermsQuery);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchPhrasePrefixQuery other = (MatchPhrasePrefixQuery)o;
        return Objects.equals(this.analyzer, other.analyzer) && this.field.equals(other.field) && Objects.equals(this.maxExpansions, other.maxExpansions) && this.query.equals(other.query) && Objects.equals(this.slop, other.slop) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MatchPhrasePrefixQuery> {
        @Nullable
        private String analyzer;
        private String field;
        @Nullable
        private Integer maxExpansions;
        private String query;
        @Nullable
        private Integer slop;
        @Nullable
        private ZeroTermsQuery zeroTermsQuery;

        public Builder() {
        }

        private Builder(MatchPhrasePrefixQuery o) {
            super(o);
            this.analyzer = o.analyzer;
            this.field = o.field;
            this.maxExpansions = o.maxExpansions;
            this.query = o.query;
            this.slop = o.slop;
            this.zeroTermsQuery = o.zeroTermsQuery;
        }

        private Builder(Builder o) {
            super(o);
            this.analyzer = o.analyzer;
            this.field = o.field;
            this.maxExpansions = o.maxExpansions;
            this.query = o.query;
            this.slop = o.slop;
            this.zeroTermsQuery = o.zeroTermsQuery;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder maxExpansions(@Nullable Integer value) {
            this.maxExpansions = value;
            return this;
        }

        @Nonnull
        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        @Nonnull
        public final Builder zeroTermsQuery(@Nullable ZeroTermsQuery value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        @Nonnull
        public MatchPhrasePrefixQuery build() {
            this._checkSingleUse();
            return new MatchPhrasePrefixQuery(this);
        }
    }
}

