/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.DistanceUnit;
import org.opensearch.client.opensearch._types.GeoDistanceType;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationRange;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoDistanceAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, GeoDistanceAggregation> {
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final String field;
    @Nullable
    private final GeoLocation origin;
    @Nonnull
    private final List<AggregationRange> ranges;
    @Nullable
    private final DistanceUnit unit;
    public static final JsonpDeserializer<GeoDistanceAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceAggregation::setupGeoDistanceAggregationDeserializer);

    private GeoDistanceAggregation(Builder builder) {
        super(builder);
        this.distanceType = builder.distanceType;
        this.field = builder.field;
        this.origin = builder.origin;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
        this.unit = builder.unit;
    }

    public static GeoDistanceAggregation of(Function<Builder, ObjectBuilder<GeoDistanceAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoDistance;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final GeoLocation origin() {
        return this.origin;
    }

    @Nonnull
    public final List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public final DistanceUnit unit() {
        return this.unit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.origin != null) {
            generator.writeKey("origin");
            this.origin.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoDistanceAggregationDeserializer(ObjectDeserializer<Builder> op) {
        GeoDistanceAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::origin, GeoLocation._DESERIALIZER, "origin");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges");
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.distanceType);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.origin);
        result = 31 * result + Objects.hashCode(this.ranges);
        result = 31 * result + Objects.hashCode(this.unit);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceAggregation other = (GeoDistanceAggregation)o;
        return Objects.equals(this.distanceType, other.distanceType) && Objects.equals(this.field, other.field) && Objects.equals(this.origin, other.origin) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.unit, other.unit);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoDistanceAggregation> {
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private String field;
        @Nullable
        private GeoLocation origin;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private DistanceUnit unit;

        public Builder() {
        }

        private Builder(GeoDistanceAggregation o) {
            super(o);
            this.distanceType = o.distanceType;
            this.field = o.field;
            this.origin = o.origin;
            this.ranges = Builder._listCopy(o.ranges);
            this.unit = o.unit;
        }

        private Builder(Builder o) {
            super(o);
            this.distanceType = o.distanceType;
            this.field = o.field;
            this.origin = o.origin;
            this.ranges = Builder._listCopy(o.ranges);
            this.unit = o.unit;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder origin(@Nullable GeoLocation value) {
            this.origin = value;
            return this;
        }

        @Nonnull
        public final Builder origin(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.origin(fn.apply(new GeoLocation.Builder()).build());
        }

        @Nonnull
        public final Builder ranges(List<AggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        @Nonnull
        public final Builder ranges(AggregationRange value, AggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        @Nonnull
        public final Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build(), new AggregationRange[0]);
        }

        @Nonnull
        public final Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoDistanceAggregation build() {
            this._checkSingleUse();
            return new GeoDistanceAggregation(this);
        }
    }
}

