/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.RemoteStoreDownloadStats;
import org.opensearch.client.opensearch._types.RemoteStoreUploadStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoteStoreStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoteStoreStats> {
    @Nonnull
    private final RemoteStoreDownloadStats download;
    @Nonnull
    private final RemoteStoreUploadStats upload;
    public static final JsonpDeserializer<RemoteStoreStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteStoreStats::setupRemoteStoreStatsDeserializer);

    private RemoteStoreStats(Builder builder) {
        this.download = ApiTypeHelper.requireNonNull(builder.download, this, "download");
        this.upload = ApiTypeHelper.requireNonNull(builder.upload, this, "upload");
    }

    public static RemoteStoreStats of(Function<Builder, ObjectBuilder<RemoteStoreStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final RemoteStoreDownloadStats download() {
        return this.download;
    }

    @Nonnull
    public final RemoteStoreUploadStats upload() {
        return this.upload;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("download");
        this.download.serialize(generator, mapper);
        generator.writeKey("upload");
        this.upload.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoteStoreStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::download, RemoteStoreDownloadStats._DESERIALIZER, "download");
        op.add(Builder::upload, RemoteStoreUploadStats._DESERIALIZER, "upload");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.download.hashCode();
        result = 31 * result + this.upload.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteStoreStats other = (RemoteStoreStats)o;
        return this.download.equals(other.download) && this.upload.equals(other.upload);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoteStoreStats> {
        private RemoteStoreDownloadStats download;
        private RemoteStoreUploadStats upload;

        public Builder() {
        }

        private Builder(RemoteStoreStats o) {
            this.download = o.download;
            this.upload = o.upload;
        }

        private Builder(Builder o) {
            this.download = o.download;
            this.upload = o.upload;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder download(RemoteStoreDownloadStats value) {
            this.download = value;
            return this;
        }

        @Nonnull
        public final Builder download(Function<RemoteStoreDownloadStats.Builder, ObjectBuilder<RemoteStoreDownloadStats>> fn) {
            return this.download(fn.apply(new RemoteStoreDownloadStats.Builder()).build());
        }

        @Nonnull
        public final Builder upload(RemoteStoreUploadStats value) {
            this.upload = value;
            return this;
        }

        @Nonnull
        public final Builder upload(Function<RemoteStoreUploadStats.Builder, ObjectBuilder<RemoteStoreUploadStats>> fn) {
            return this.upload(fn.apply(new RemoteStoreUploadStats.Builder()).build());
        }

        @Override
        @Nonnull
        public RemoteStoreStats build() {
            this._checkSingleUse();
            return new RemoteStoreStats(this);
        }
    }
}

