/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.impl.ArrayExample;
import org.tribuo.impl.BinaryFeaturesExample;
import org.tribuo.util.Merger;

public class SequenceExample<T extends Output<T>>
implements Iterable<Example<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SequenceExample.class.getName());
    public static final float DEFAULT_WEIGHT = 1.0f;
    private final List<Example<T>> examples;
    private float weight = 1.0f;

    public SequenceExample() {
        this(new ArrayList<Example<T>>());
    }

    public SequenceExample(List<Example<T>> examples) {
        this(examples, 1.0f);
    }

    public SequenceExample(List<Example<T>> examples, float weight) {
        this.examples = examples;
        this.weight = weight;
    }

    public SequenceExample(List<T> outputs, List<? extends List<? extends Feature>> features) {
        this(outputs, features, 1.0f);
    }

    public SequenceExample(List<T> outputs, List<? extends List<? extends Feature>> features, float weight) {
        this(outputs, features, weight, false);
    }

    public SequenceExample(List<T> outputs, List<? extends List<? extends Feature>> features, boolean attemptBinaryFeatures) {
        this(outputs, features, 1.0f, attemptBinaryFeatures);
    }

    public SequenceExample(List<T> outputs, List<? extends List<? extends Feature>> features, float weight, boolean attemptBinaryFeatures) {
        if (outputs.size() != features.size()) {
            throw new IllegalArgumentException("outputs.size() = " + outputs.size() + ", features.size() = " + features.size());
        }
        ArrayList<Example<T>> examples = new ArrayList<Example<T>>(outputs.size());
        for (int i = 0; i < outputs.size(); ++i) {
            List<? extends Feature> list = features.get(i);
            Example example = null;
            if (attemptBinaryFeatures) {
                try {
                    example = new BinaryFeaturesExample<Output>((Output)outputs.get(i), list);
                }
                catch (IllegalArgumentException iae) {
                    logger.finer("attempted to create BinaryFeaturesExample but not all of the features were binary");
                    example = new ArrayExample<Output>((Output)outputs.get(i), list);
                }
            } else {
                example = new ArrayExample<Output>((Output)outputs.get(i), list);
            }
            examples.add(example);
        }
        this.examples = examples;
        this.weight = weight;
    }

    public SequenceExample(SequenceExample<T> other) {
        this.examples = new ArrayList<Example<T>>(other.size());
        for (Example<T> example : other) {
            this.examples.add(example.copy());
        }
        this.weight = other.weight;
    }

    public int size() {
        return this.examples.size();
    }

    public void removeFeatures(List<Feature> features) {
        for (Example<T> e : this.examples) {
            e.removeFeatures(features);
        }
    }

    public Example<T> get(int i) {
        return this.examples.get(i);
    }

    public boolean validateExample() {
        if (this.examples.isEmpty()) {
            return false;
        }
        boolean valid = true;
        for (Example<T> e : this.examples) {
            valid &= e.validateExample();
        }
        return valid;
    }

    public void reduceByName(Merger merger) {
        for (Example<T> e : this.examples) {
            e.reduceByName(merger);
        }
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public float getWeight() {
        return this.weight;
    }

    public void addExample(Example<T> e) {
        this.examples.add(e);
    }

    public SequenceExample<T> copy() {
        return new SequenceExample<T>(this);
    }

    @Override
    public Iterator<Example<T>> iterator() {
        return this.examples.iterator();
    }

    public Iterator<Feature> featureIterator() {
        return new FeatureIterator<T>(this.iterator());
    }

    public boolean isDense(FeatureMap fMap) {
        for (Example<T> e : this.examples) {
            if (e.isDense(fMap)) continue;
            return false;
        }
        return true;
    }

    public void densify(FeatureMap fMap) {
        for (Example<T> e : this.examples) {
            e.densify(fMap);
        }
    }

    public void canonicalise(FeatureMap featureMap) {
        for (Example<T> e : this.examples) {
            e.canonicalize(featureMap);
        }
    }

    public static <T extends Output<T>> SequenceExample<T> createWithEmptyOutputs(List<? extends List<? extends Feature>> features, OutputFactory<T> outputFactory) {
        ArrayList<Example<T>> examples = new ArrayList<Example<T>>(features.size());
        for (List<? extends Feature> list : features) {
            ArrayExample<T> example = new ArrayExample<T>(outputFactory.getUnknownOutput());
            example.addAll(list);
            examples.add(example);
        }
        return new SequenceExample<T>(examples);
    }

    private static class FeatureIterator<T extends Output<T>>
    implements Iterator<Feature> {
        private final Iterator<Example<T>> itr;
        private Iterator<Feature> featureItr;

        public FeatureIterator(Iterator<Example<T>> e) {
            this.itr = e;
        }

        @Override
        public boolean hasNext() {
            if (this.featureItr != null && this.featureItr.hasNext()) {
                return true;
            }
            if (this.itr.hasNext()) {
                while (this.itr.hasNext()) {
                    this.featureItr = this.itr.next().iterator();
                    if (!this.featureItr.hasNext()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public Feature next() {
            if (this.featureItr != null) {
                return this.featureItr.next();
            }
            return null;
        }
    }
}

