/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;

@ToolAnnotation(value="ReadFromScratchPadTool")
public class ReadFromScratchPadTool
implements Tool {
    public static final String TYPE = "ReadFromScratchPadTool";
    public static final String STRICT_FIELD = "strict";
    public static final String SCRATCHPAD_NOTES_KEY = "_scratchpad_notes";
    public static final String NOTES_KEY = "notes";
    public static final String PERSISTENT_NOTES_KEY = "persistent_notes";
    private static final String DEFAULT_DESCRIPTION = "Retrieve previous research work and notes from the persistent scratchpad.";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{}}";
    private String name = "ReadFromScratchPadTool";
    private String description = "Retrieve previous research work and notes from the persistent scratchpad.";
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public ReadFromScratchPadTool() {
        this.attributes.put("input_schema", DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, true);
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return "1";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        List parsedNotes;
        Map<String, String> rawParameters = parameters;
        String existingNotes = rawParameters.get(SCRATCHPAD_NOTES_KEY);
        ArrayList<String> notes = existingNotes instanceof List ? new ArrayList<String>((List)((Object)existingNotes)) : (existingNotes instanceof String ? ((parsedNotes = StringUtils.parseStringArrayToList((String)existingNotes)) != null ? new ArrayList(parsedNotes) : new ArrayList()) : new ArrayList());
        String persistentNotes = parameters.getOrDefault(PERSISTENT_NOTES_KEY, "");
        if (persistentNotes != null && !persistentNotes.isEmpty() && !notes.contains(persistentNotes)) {
            notes.add(persistentNotes);
        }
        rawParameters.put(SCRATCHPAD_NOTES_KEY, (String)((Object)notes));
        if (notes.isEmpty()) {
            listener.onResponse((Object)"Scratchpad is empty.");
        } else {
            String formattedNotes = "- " + String.join((CharSequence)"\n- ", notes);
            listener.onResponse((Object)("Notes from scratchpad:\n" + formattedNotes));
        }
    }

    public static class Factory
    implements Tool.Factory<ReadFromScratchPadTool> {
        private static Factory INSTANCE;

        public static Factory getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new Factory();
            }
            return INSTANCE;
        }

        public void init() {
        }

        public ReadFromScratchPadTool create(Map<String, Object> params) {
            return new ReadFromScratchPadTool();
        }

        public String getDefaultDescription() {
            return ReadFromScratchPadTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return ReadFromScratchPadTool.TYPE;
        }

        public String getDefaultVersion() {
            return "1";
        }

        public Map<String, Object> getDefaultAttributes() {
            return Map.of("input_schema", ReadFromScratchPadTool.DEFAULT_INPUT_SCHEMA, ReadFromScratchPadTool.STRICT_FIELD, true);
        }
    }
}

