/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.anomalylocalization;

import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.output.execute.anomalylocalization.Counter;

public class CountSketch
implements Counter {
    @Generated
    private static final Logger log = LogManager.getLogger(CountSketch.class);
    protected static final double INV_DELTOID = 100.0;
    protected static final double LOG_BASE_2 = 2.0;
    protected static final double INV_EPSILON = 1000.0;
    private int numHashes = (int)Math.ceil(Math.log(100.0) / Math.log(2.0));
    private int numBuckets = (int)Math.ceil(1000.0);
    private double[][] counts = new double[this.numHashes][this.numBuckets];
    private int[] hashes;
    private int[] signHashes;

    public CountSketch() {
        Random random = new Random();
        this.hashes = random.ints(this.numHashes).toArray();
        this.signHashes = random.ints(this.numHashes).toArray();
        log.info("count sketch size " + this.numHashes + " * " + this.numBuckets + " = " + this.numHashes * this.numBuckets);
    }

    public void increment(List<String> key, double value) {
        int keyHash = key.hashCode();
        for (int i = 0; i < this.numHashes; ++i) {
            double[] dArray = this.counts[i];
            int n = this.getBucketIndex(keyHash, i);
            dArray[n] = dArray[n] + (double)this.getCountSign(keyHash, i) * value;
        }
    }

    public double estimate(List<String> key) {
        int keyHash = key.hashCode();
        double[] estimates = IntStream.range(0, this.numHashes).mapToDouble(i -> this.counts[i][this.getBucketIndex(keyHash, i)] * (double)this.getCountSign(keyHash, i)).sorted().toArray();
        int numEstimates = estimates.length;
        return (estimates[(numEstimates - 1) / 2] + estimates[numEstimates / 2]) / 2.0;
    }

    private int getBucketIndex(int keyHash, int hashIndex) {
        return Math.floorMod(this.hashes[hashIndex] ^ keyHash, this.numBuckets);
    }

    private int getCountSign(int keyHash, int hashIndex) {
        return Math.floorMod(this.signHashes[hashIndex] ^ keyHash, 2) * 2 - 1;
    }
}

