/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.command;

import com.oracle.labs.mlrg.olcut.command.CommandInterface;
import com.oracle.labs.mlrg.olcut.command.CommandInterpreter;
import java.util.Map;

public class LayeredCommandInterpreter
extends CommandInterpreter {
    private final String layerTag;
    private final String layerName;

    public LayeredCommandInterpreter(String layerTag, String layerName) {
        super(false);
        this.layerTag = layerTag;
        this.layerName = layerName;
    }

    @Override
    protected void dumpCommands() {
        int count = 0;
        for (CommandInterpreter.CommandGroupInternal cg : this.commandGroups.values()) {
            if (cg.getGroupName().equals("Standard")) continue;
            count = this.dumpGroup(cg, count);
        }
        for (LayeredCommandInterpreter lci : this.interpreters) {
            this.putResponse(String.format("Commands labeled %s", lci.getLayerTag()));
            lci.dumpCommands();
        }
    }

    public String getLayerTag() {
        return this.layerTag;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public Map<String, CommandInterface> getCommands() {
        return this.commands;
    }

    public Map<String, CommandInterpreter.CommandGroupInternal> getCommandGroups() {
        return this.commandGroups;
    }

    @Override
    public String toString() {
        return "LayeredCommandInterpreter name: " + this.layerName + ", tag: " + this.layerTag;
    }
}

