/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReasoningContentBlockDelta
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReasoningContentBlockDelta> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ReasoningContentBlockDelta.getter(ReasoningContentBlockDelta::text)).setter(ReasoningContentBlockDelta.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<SdkBytes> REDACTED_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("redactedContent").getter(ReasoningContentBlockDelta.getter(ReasoningContentBlockDelta::redactedContent)).setter(ReasoningContentBlockDelta.setter(Builder::redactedContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactedContent").build()}).build();
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signature").getter(ReasoningContentBlockDelta.getter(ReasoningContentBlockDelta::signature)).setter(ReasoningContentBlockDelta.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, REDACTED_CONTENT_FIELD, SIGNATURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReasoningContentBlockDelta.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final SdkBytes redactedContent;
    private final String signature;
    private final Type type;

    private ReasoningContentBlockDelta(BuilderImpl builder) {
        this.text = builder.text;
        this.redactedContent = builder.redactedContent;
        this.signature = builder.signature;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final SdkBytes redactedContent() {
        return this.redactedContent;
    }

    public final String signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactedContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReasoningContentBlockDelta)) {
            return false;
        }
        ReasoningContentBlockDelta other = (ReasoningContentBlockDelta)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.redactedContent(), other.redactedContent()) && Objects.equals(this.signature(), other.signature());
    }

    public final String toString() {
        return ToString.builder((String)"ReasoningContentBlockDelta").add("Text", (Object)this.text()).add("RedactedContent", (Object)this.redactedContent()).add("Signature", (Object)this.signature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "redactedContent": {
                return Optional.ofNullable(clazz.cast(this.redactedContent()));
            }
            case "signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
        }
        return Optional.empty();
    }

    public static ReasoningContentBlockDelta fromText(String text) {
        return (ReasoningContentBlockDelta)ReasoningContentBlockDelta.builder().text(text).build();
    }

    public static ReasoningContentBlockDelta fromRedactedContent(SdkBytes redactedContent) {
        return (ReasoningContentBlockDelta)ReasoningContentBlockDelta.builder().redactedContent(redactedContent).build();
    }

    public static ReasoningContentBlockDelta fromSignature(String signature) {
        return (ReasoningContentBlockDelta)ReasoningContentBlockDelta.builder().signature(signature).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("redactedContent", REDACTED_CONTENT_FIELD);
        map.put("signature", SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReasoningContentBlockDelta, T> g) {
        return obj -> g.apply((ReasoningContentBlockDelta)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        REDACTED_CONTENT,
        SIGNATURE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private SdkBytes redactedContent;
        private String signature;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReasoningContentBlockDelta model) {
            this.text(model.text);
            this.redactedContent(model.redactedContent);
            this.signature(model.signature);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ByteBuffer getRedactedContent() {
            return this.redactedContent == null ? null : this.redactedContent.asByteBuffer();
        }

        public final void setRedactedContent(ByteBuffer redactedContent) {
            this.redactedContent(redactedContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)redactedContent));
        }

        @Override
        public final Builder redactedContent(SdkBytes redactedContent) {
            SdkBytes oldValue = this.redactedContent;
            this.redactedContent = redactedContent;
            this.handleUnionValueChange(Type.REDACTED_CONTENT, oldValue, this.redactedContent);
            return this;
        }

        public final String getSignature() {
            return this.signature;
        }

        public final void setSignature(String signature) {
            String oldValue = this.signature;
            this.signature = signature;
            this.handleUnionValueChange(Type.SIGNATURE, oldValue, this.signature);
        }

        @Override
        public final Builder signature(String signature) {
            String oldValue = this.signature;
            this.signature = signature;
            this.handleUnionValueChange(Type.SIGNATURE, oldValue, this.signature);
            return this;
        }

        public ReasoningContentBlockDelta build() {
            return new ReasoningContentBlockDelta(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReasoningContentBlockDelta> {
        public Builder text(String var1);

        public Builder redactedContent(SdkBytes var1);

        public Builder signature(String var1);
    }
}

