/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.BoundingBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;

public class ConditionalTreeSample {
    public int pointStoreIndex;
    protected BoundingBox parentOfLeafBox;
    public double distance;
    public float[] leafPoint;
    public double weight;
    public static Collector<ConditionalTreeSample, ArrayList<ConditionalTreeSample>, ArrayList<ConditionalTreeSample>> collector = Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
        left.addAll(right);
        return left;
    }, list -> list, new Collector.Characteristics[0]);

    public ConditionalTreeSample(int pointStoreIndex, BoundingBox box, double distance, float[] leafPoint) {
        this.pointStoreIndex = pointStoreIndex;
        this.parentOfLeafBox = box;
        this.distance = distance;
        this.leafPoint = leafPoint;
        this.weight = 1.0;
    }

    public static List<ConditionalTreeSample> dedup(List<ConditionalTreeSample> list) {
        list.sort(Comparator.comparingInt(o -> o.pointStoreIndex));
        ArrayList<ConditionalTreeSample> newList = new ArrayList<ConditionalTreeSample>();
        newList.add(list.get(0));
        for (int j = 1; j < list.size(); ++j) {
            if (list.get((int)j).pointStoreIndex == ((ConditionalTreeSample)newList.get((int)(newList.size() - 1))).pointStoreIndex) {
                ((ConditionalTreeSample)newList.get((int)(newList.size() - 1))).weight += list.get((int)j).weight;
                continue;
            }
            newList.add(list.get(j));
        }
        return newList;
    }

    public ConditionalTreeSample(double[] point) {
        this.pointStoreIndex = 0;
        this.leafPoint = CommonUtils.toFloatArray(point);
        this.weight = 1.0;
    }
}

