/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.IComponentModel;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.executor.AbstractForestTraversalExecutor;
import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class SequentialForestTraversalExecutor
extends AbstractForestTraversalExecutor {
    public SequentialForestTraversalExecutor(ComponentList<?, ?> components) {
        super(components);
    }

    @Override
    public <R, S> S traverseForest(float[] point, IVisitorFactory<R> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        Object unnormalizedResult = this.components.stream().map(c -> c.traverse(point, visitorFactory)).reduce(accumulator).orElseThrow(() -> new IllegalStateException("accumulator returned an empty result"));
        return finisher.apply(unnormalizedResult);
    }

    @Override
    public <R, S> S traverseForest(float[] point, IVisitorFactory<R> visitorFactory, Collector<R, ?, S> collector) {
        return this.components.stream().map(c -> c.traverse(point, visitorFactory)).collect(collector);
    }

    @Override
    public <R, S> S traverseForest(float[] point, IVisitorFactory<R> visitorFactory, ConvergingAccumulator<R> accumulator, Function<R, S> finisher) {
        for (IComponentModel component : this.components) {
            accumulator.accept(component.traverse(point, visitorFactory));
            if (!accumulator.isConverged()) continue;
            break;
        }
        return finisher.apply(accumulator.getAccumulatedValue());
    }

    @Override
    public <R, S> S traverseForestMulti(float[] point, IMultiVisitorFactory<R> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        Object unnormalizedResult = this.components.stream().map(c -> c.traverseMulti(point, visitorFactory)).reduce(accumulator).orElseThrow(() -> new IllegalStateException("accumulator returned an empty result"));
        return finisher.apply(unnormalizedResult);
    }

    @Override
    public <R, S> S traverseForestMulti(float[] point, IMultiVisitorFactory<R> visitorFactory, Collector<R, ?, S> collector) {
        return this.components.stream().map(c -> c.traverseMulti(point, visitorFactory)).collect(collector);
    }
}

