/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.language.DaitchMokotoffSoundex;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public final class DaitchMokotoffSoundexFilter
extends TokenFilter {
    private final boolean inject;
    private final DaitchMokotoffSoundex encoder = new DaitchMokotoffSoundex();
    private static final Pattern pattern = Pattern.compile("([^|]+)");
    private final Matcher matcher = pattern.matcher("");
    private String encoded;
    private AttributeSource.State state;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    public DaitchMokotoffSoundexFilter(TokenStream in, boolean inject) {
        super(in);
        this.inject = inject;
    }

    public boolean incrementToken() throws IOException {
        if (this.matcher.find()) {
            assert (this.state != null && this.encoded != null);
            this.restoreState(this.state);
            this.termAtt.setEmpty().append((CharSequence)this.encoded, this.matcher.start(1), this.matcher.end(1));
            this.posAtt.setPositionIncrement(0);
            return true;
        }
        if (this.input.incrementToken()) {
            if (this.termAtt.length() == 0) {
                return true;
            }
            this.encoded = this.encoder.soundex(this.termAtt.toString());
            this.state = this.captureState();
            this.matcher.reset(this.encoded);
            if (!this.inject && this.matcher.find()) {
                this.termAtt.setEmpty().append((CharSequence)this.encoded, this.matcher.start(1), this.matcher.end(1));
            }
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.matcher.reset("");
        this.state = null;
    }
}

