/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.completion;

public class CharSequenceUtils {
    public static boolean isLowercaseAlphabets(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (CharSequenceUtils.isHalfWidthLowercaseAlphabet(ch) || CharSequenceUtils.isFullWidthLowercaseAlphabet(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isKana(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (CharSequenceUtils.isHiragana(ch) || CharSequenceUtils.isKatakana(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isKatakanaOrHWAlphabets(CharSequence ref) {
        for (int i = 0; i < ref.length(); ++i) {
            char ch = ref.charAt(i);
            if (CharSequenceUtils.isKatakana(ch) || CharSequenceUtils.isHalfWidthLowercaseAlphabet(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHiragana(char ch) {
        return ch >= '\u3040' && ch <= '\u309f';
    }

    private static boolean isKatakana(char ch) {
        return ch >= '\u30a0' && ch <= '\u30ff';
    }

    private static boolean isHalfWidthLowercaseAlphabet(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isFullWidthLowercaseAlphabet(char ch) {
        return ch >= '\uff41' && ch <= '\uff5a';
    }

    public static String toKatakana(CharSequence s) {
        char[] chars = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            chars[i] = ch >= '\u3041' && ch <= '\u3096' || ch == '\u309d' || ch == '\u309e' ? (char)(ch + 96) : ch;
        }
        return new String(chars);
    }

    private CharSequenceUtils() {
    }
}

