/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.filecache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.admin.cluster.filecache.NodePruneFileCacheResponse;
import org.opensearch.action.admin.cluster.filecache.PruneFileCacheRequest;
import org.opensearch.action.admin.cluster.filecache.PruneFileCacheResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;

public class TransportPruneFileCacheAction
extends TransportNodesAction<PruneFileCacheRequest, PruneFileCacheResponse, NodeRequest, NodePruneFileCacheResponse> {
    private final FileCache fileCache;

    @Inject
    public TransportPruneFileCacheAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, @Nullable FileCache fileCache) {
        super("cluster:admin/filecache/prune", threadPool, clusterService, transportService, actionFilters, PruneFileCacheRequest::new, NodeRequest::new, "management", NodePruneFileCacheResponse.class);
        this.fileCache = fileCache;
    }

    @Override
    protected void resolveRequest(PruneFileCacheRequest request, ClusterState clusterState) {
        List<DiscoveryNode> warmNodes;
        assert (request.concreteNodes() == null) : "request concreteNodes shouldn't be set";
        ArrayList<DiscoveryNode> allWarmNodes = new ArrayList<DiscoveryNode>(clusterState.nodes().getWarmNodes().values());
        if (request.nodesIds() != null && request.nodesIds().length > 0) {
            String[] resolvedNodeIds = clusterState.nodes().resolveNodes(request.nodesIds());
            Set<String> requestedIds = Set.of(resolvedNodeIds);
            warmNodes = allWarmNodes.stream().filter(node -> requestedIds.contains(node.getId())).collect(Collectors.toList());
            if (warmNodes.isEmpty()) {
                throw new IllegalArgumentException("No warm nodes found matching the specified criteria. FileCache operations can only target warm nodes.");
            }
        } else {
            warmNodes = allWarmNodes;
        }
        request.setConcreteNodes(warmNodes.toArray(new DiscoveryNode[warmNodes.size()]));
    }

    @Override
    protected PruneFileCacheResponse newResponse(PruneFileCacheRequest request, List<NodePruneFileCacheResponse> responses, List<FailedNodeException> failures) {
        return new PruneFileCacheResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(PruneFileCacheRequest request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodePruneFileCacheResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodePruneFileCacheResponse(in);
    }

    @Override
    protected NodePruneFileCacheResponse nodeOperation(NodeRequest nodeRequest) {
        if (this.fileCache == null) {
            return new NodePruneFileCacheResponse(this.transportService.getLocalNode(), 0L, 0L);
        }
        try {
            long capacity = this.fileCache.capacity();
            long prunedBytes = this.fileCache.prune();
            return new NodePruneFileCacheResponse(this.transportService.getLocalNode(), prunedBytes, capacity);
        }
        catch (Exception e) {
            throw new RuntimeException("FileCache prune operation failed on node " + this.transportService.getLocalNode().getId(), e);
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private PruneFileCacheRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new PruneFileCacheRequest(in);
        }

        public NodeRequest(PruneFileCacheRequest request) {
            this.request = Objects.requireNonNull(request, "PruneFileCacheRequest cannot be null");
        }

        public PruneFileCacheRequest getRequest() {
            return this.request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

