/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCrossJoin;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaDerivedJoin;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaJoin;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public interface SqmJoin<L, R>
extends SqmFrom<L, R>,
JpaJoin<L, R> {
    public SqmJoinType getSqmJoinType();

    public boolean isImplicitlySelectable();

    public SqmPredicate getJoinPredicate();

    public void setJoinPredicate(SqmPredicate var1);

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> join(String var1);

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> join(String var1, JoinType var2);

    @Override
    public SqmJoin<L, R> copy(SqmCopyContext var1);

    @Override
    public <S extends R> SqmTreatedJoin<L, R, S> treatAs(Class<S> var1);

    @Override
    public <S extends R> SqmTreatedJoin<L, R, S> treatAs(EntityDomainType<S> var1);

    @Override
    public <S extends R> SqmTreatedJoin<L, R, S> treatAs(Class<S> var1, String var2);

    @Override
    public <S extends R> SqmTreatedJoin<L, R, S> treatAs(EntityDomainType<S> var1, String var2);

    default public SqmPredicate getOn() {
        return this.getJoinPredicate();
    }

    @Override
    default public SqmJoin<L, R> on(JpaExpression<Boolean> restriction) {
        this.setJoinPredicate(SqmCreationHelper.combinePredicates(this.getJoinPredicate(), (SqmPredicate)this.getJoinPredicate().nodeBuilder().wrap(restriction)));
        return this;
    }

    @Override
    default public SqmJoin<L, R> on(Expression<Boolean> restriction) {
        this.setJoinPredicate(SqmCreationHelper.combinePredicates(this.getJoinPredicate(), (SqmPredicate)this.getJoinPredicate().nodeBuilder().wrap((Expression)restriction)));
        return this;
    }

    @Override
    default public SqmJoin<L, R> on(JpaPredicate ... restrictions) {
        this.setJoinPredicate(SqmCreationHelper.combinePredicates(this.getJoinPredicate(), restrictions));
        return this;
    }

    @Override
    default public SqmJoin<L, R> on(Predicate ... restrictions) {
        this.setJoinPredicate(SqmCreationHelper.combinePredicates(this.getJoinPredicate(), restrictions));
        return this;
    }

    @Override
    default public <X> JpaEntityJoin<R, X> join(Class<X> entityJavaType, SqmJoinType joinType) {
        return SqmFrom.super.join(entityJavaType, joinType);
    }

    @Override
    public <Y> JpaJoin<R, Y> join(EntityType<Y> var1);

    @Override
    public <Y> JpaJoin<R, Y> join(EntityType<Y> var1, JoinType var2);

    @Override
    public <X> JpaEntityJoin<R, X> join(EntityDomainType<X> var1);

    @Override
    public <X> JpaEntityJoin<R, X> join(EntityDomainType<X> var1, SqmJoinType var2);

    @Override
    public <X> JpaDerivedJoin<X> join(Subquery<X> var1);

    @Override
    public <X> JpaDerivedJoin<X> join(Subquery<X> var1, SqmJoinType var2);

    @Override
    public <X> JpaDerivedJoin<X> joinLateral(Subquery<X> var1);

    @Override
    public <X> JpaDerivedJoin<X> joinLateral(Subquery<X> var1, SqmJoinType var2);

    @Override
    public <X> JpaDerivedJoin<X> join(Subquery<X> var1, SqmJoinType var2, boolean var3);

    @Override
    public <X> JpaJoin<?, X> join(JpaCteCriteria<X> var1);

    @Override
    public <X> JpaJoin<?, X> join(JpaCteCriteria<X> var1, SqmJoinType var2);

    @Override
    public <X> JpaCrossJoin<X> crossJoin(Class<X> var1);

    @Override
    public <X> JpaCrossJoin<X> crossJoin(EntityDomainType<X> var1);

    @Override
    public <A> SqmSingularJoin<R, A> join(SingularAttribute<? super R, A> var1);

    @Override
    public <A> SqmSingularJoin<R, A> join(SingularAttribute<? super R, A> var1, JoinType var2);

    @Override
    public <E> SqmBagJoin<R, E> join(CollectionAttribute<? super R, E> var1);

    @Override
    public <E> SqmBagJoin<R, E> join(CollectionAttribute<? super R, E> var1, JoinType var2);

    @Override
    public <E> SqmSetJoin<R, E> join(SetAttribute<? super R, E> var1);

    @Override
    public <E> SqmSetJoin<R, E> join(SetAttribute<? super R, E> var1, JoinType var2);

    @Override
    public <E> SqmListJoin<R, E> join(ListAttribute<? super R, E> var1);

    @Override
    public <E> SqmListJoin<R, E> join(ListAttribute<? super R, E> var1, JoinType var2);

    @Override
    public <K, V> SqmMapJoin<R, K, V> join(MapAttribute<? super R, K, V> var1);

    @Override
    public <K, V> SqmMapJoin<R, K, V> join(MapAttribute<? super R, K, V> var1, JoinType var2);

    @Override
    public <X, Y> SqmBagJoin<X, Y> joinCollection(String var1);

    @Override
    public <X, Y> SqmBagJoin<X, Y> joinCollection(String var1, JoinType var2);

    @Override
    public <X, Y> SqmSetJoin<X, Y> joinSet(String var1);

    @Override
    public <X, Y> SqmSetJoin<X, Y> joinSet(String var1, JoinType var2);

    @Override
    public <X, Y> SqmListJoin<X, Y> joinList(String var1);

    @Override
    public <X, Y> SqmListJoin<X, Y> joinList(String var1, JoinType var2);

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> joinMap(String var1);

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> joinMap(String var1, JoinType var2);
}

