/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class InsertRowsCoordinatorStandard
implements InsertRowsCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final RowMutationOperations rowMutationOperations;
    private final BasicBatchKey batchKey;
    private final MutationExecutorService mutationExecutorService;
    private MutationOperationGroup operationGroup;

    public InsertRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, ServiceRegistry serviceRegistry) {
        this.mutationTarget = mutationTarget;
        this.rowMutationOperations = rowMutationOperations;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#INSERT");
        this.mutationExecutorService = serviceRegistry.getService(MutationExecutorService.class);
    }

    public String toString() {
        return "InsertRowsCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRows(PersistentCollection<?> collection, Object id, InsertRowsCoordinator.EntryFilter entryChecker, SharedSessionContractImplementor session) {
        if (this.operationGroup == null) {
            this.operationGroup = this.createOperationGroup();
        }
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Inserting collection rows - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
        }
        PluralAttributeMapping pluralAttribute = this.mutationTarget.getTargetPart();
        CollectionPersister collectionDescriptor = pluralAttribute.getCollectionDescriptor();
        MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> this.batchKey, this.operationGroup, session);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        try {
            Iterator<?> entries = collection.entries(collectionDescriptor);
            collection.preInsert(collectionDescriptor);
            if (!entries.hasNext()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("No collection rows to insert - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
                return;
            }
            int entryCount = 0;
            RowMutationOperations.Values insertRowValues = this.rowMutationOperations.getInsertRowValues();
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (entryChecker == null || entryChecker.include(entry, entryCount, collection, pluralAttribute)) {
                    insertRowValues.applyValues(collection, id, entry, entryCount, session, jdbcValueBindings);
                    mutationExecutor.execute(entry, null, null, null, session);
                }
                ++entryCount;
            }
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Done inserting %s collection rows : %s", entryCount, (Object)this.mutationTarget.getRolePath());
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroup createOperationGroup() {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation();
        return MutationOperationGroupFactory.singleOperation(MutationType.INSERT, this.mutationTarget, operation);
    }
}

