/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Objects;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;

public class CheckConstraint {
    private String name;
    private String constraint;
    private String options;

    public CheckConstraint(String name, String constraint) {
        this.name = name;
        this.constraint = constraint;
    }

    public CheckConstraint(String name, String constraint, String options) {
        this.name = name;
        this.constraint = constraint;
        this.options = options;
    }

    public CheckConstraint(String constraint) {
        this.constraint = constraint;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getConstraintInParens() {
        return "(" + this.constraint + ")";
    }

    public void setConstraint(String constraint) {
        this.constraint = constraint;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    @Deprecated(since="7.0")
    public String constraintString() {
        return StringHelper.isBlank(this.name) ? " check (" + this.constraint + ")" : " constraint " + this.name + " check (" + this.constraint + ")";
    }

    public String constraintString(Dialect dialect) {
        return dialect.getCheckConstraintString(this);
    }

    public boolean equals(Object object) {
        if (object instanceof CheckConstraint) {
            CheckConstraint other = (CheckConstraint)object;
            return Objects.equals(this.name, other.name) && Objects.equals(this.constraint, other.constraint);
        }
        return false;
    }

    public int hashCode() {
        return this.constraint.hashCode();
    }
}

