/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Function;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.hibernate.boot.jaxb.internal.FileXmlSource;
import org.hibernate.boot.jaxb.internal.InputStreamAccessXmlSource;
import org.hibernate.boot.jaxb.internal.InputStreamXmlSource;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.internal.UrlXmlSource;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.service.ServiceRegistry;

public class XmlMappingBinderAccess {
    private final ClassLoaderService classLoaderService;
    private final MappingBinder mappingBinder;

    public XmlMappingBinderAccess(ServiceRegistry serviceRegistry) {
        this.classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        this.mappingBinder = new MappingBinder(serviceRegistry);
    }

    public XmlMappingBinderAccess(ServiceRegistry serviceRegistry, Function<String, Object> configAccess) {
        this.classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        this.mappingBinder = new MappingBinder((ResourceStreamLocator)this.classLoaderService, configAccess);
    }

    public MappingBinder getMappingBinder() {
        return this.mappingBinder;
    }

    public Binding<JaxbBindableMappingDescriptor> bind(String resource) {
        return UrlXmlSource.fromResource(resource, this.classLoaderService, this.getMappingBinder());
    }

    public Binding<JaxbBindableMappingDescriptor> bind(File file) {
        return FileXmlSource.fromFile(file, this.getMappingBinder());
    }

    public Binding<JaxbBindableMappingDescriptor> bind(InputStreamAccess xmlInputStreamAccess) {
        return InputStreamAccessXmlSource.fromStreamAccess(xmlInputStreamAccess, this.getMappingBinder());
    }

    public Binding<JaxbBindableMappingDescriptor> bind(InputStream xmlInputStream) {
        return InputStreamXmlSource.fromStream(xmlInputStream, this.getMappingBinder());
    }

    public Binding<JaxbBindableMappingDescriptor> bind(URL url) {
        return UrlXmlSource.fromUrl(url, this.getMappingBinder());
    }
}

