/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

public final class ForwardingManagerMetrics
implements AutoCloseable {
    private final Metrics metrics;
    private static final String METRIC_GROUP_NAME = "ForwardingManager";
    private static final String QUEUE_TIME_MS_NAME = "QueueTimeMs";
    private static final String REMOTE_TIME_MS_NAME = "RemoteTimeMs";
    private final LatencyHistogram queueTimeMsHist;
    private final LatencyHistogram remoteTimeMsHist;
    private final MetricName queueLengthName;
    private final AtomicInteger queueLength = new AtomicInteger(0);

    public ForwardingManagerMetrics(Metrics metrics, long timeoutMs) {
        this.metrics = metrics;
        this.queueTimeMsHist = new LatencyHistogram(metrics, QUEUE_TIME_MS_NAME, METRIC_GROUP_NAME, timeoutMs);
        this.remoteTimeMsHist = new LatencyHistogram(metrics, REMOTE_TIME_MS_NAME, METRIC_GROUP_NAME, timeoutMs);
        this.queueLengthName = metrics.metricName("QueueLength", METRIC_GROUP_NAME, "The current number of RPCs that are waiting in the broker's forwarding manager queue, waiting to be sent to the controller.");
        metrics.addMetric(this.queueLengthName, (MetricValueProvider)((Gauge)(config, now) -> this.queueLength.get()));
    }

    @Override
    public void close() {
        this.queueTimeMsHist.close();
        this.remoteTimeMsHist.close();
        this.metrics.removeMetric(this.queueLengthName);
    }

    public LatencyHistogram queueTimeMsHist() {
        return this.queueTimeMsHist;
    }

    public LatencyHistogram remoteTimeMsHist() {
        return this.remoteTimeMsHist;
    }

    public MetricName queueLengthName() {
        return this.queueLengthName;
    }

    public void incrementQueueLength() {
        this.queueLength.getAndIncrement();
    }

    public void decrementQueueLength() {
        this.queueLength.getAndDecrement();
    }

    public static final class LatencyHistogram
    implements AutoCloseable {
        private static final int SIZE_IN_BYTES = 4000;
        private final Metrics metrics;
        private final String name;
        private final Sensor sensor;
        private final MetricName latencyP99Name;
        private final MetricName latencyP999Name;

        private LatencyHistogram(Metrics metrics, String name, String group, long maxLatency) {
            this.metrics = metrics;
            this.name = name;
            this.sensor = metrics.sensor(name);
            this.latencyP99Name = metrics.metricName(name + ".p99", group);
            this.latencyP999Name = metrics.metricName(name + ".p999", group);
            this.sensor.add((CompoundStat)new Percentiles(4000, (double)maxLatency, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.latencyP99Name, 99.0), new Percentile(this.latencyP999Name, 99.9)}));
        }

        @Override
        public void close() {
            this.metrics.removeSensor(this.name);
            this.metrics.removeMetric(this.latencyP99Name);
            this.metrics.removeMetric(this.latencyP999Name);
        }

        public void record(long latencyMs) {
            this.sensor.record((double)latencyMs);
        }

        public MetricName latencyP99Name() {
            return this.latencyP99Name;
        }

        public MetricName latencyP999Name() {
            return this.latencyP999Name;
        }
    }
}

