/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.assignor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.streams.assignor.TaskId;

public class ProcessState {
    private final String processId;
    private int capacity;
    private double load;
    private final Map<String, Integer> memberToTaskCounts;
    private final Map<String, Set<TaskId>> assignedActiveTasks;
    private final Map<String, Set<TaskId>> assignedStandbyTasks;

    ProcessState(String processId) {
        this.processId = processId;
        this.capacity = 0;
        this.load = Double.MAX_VALUE;
        this.assignedActiveTasks = new HashMap<String, Set<TaskId>>();
        this.assignedStandbyTasks = new HashMap<String, Set<TaskId>>();
        this.memberToTaskCounts = new HashMap<String, Integer>();
    }

    public String processId() {
        return this.processId;
    }

    public int capacity() {
        return this.capacity;
    }

    public int totalTaskCount() {
        return this.assignedStandbyTasks().size() + this.assignedActiveTasks().size();
    }

    public double load() {
        return this.load;
    }

    public Map<String, Integer> memberToTaskCounts() {
        return this.memberToTaskCounts;
    }

    public Set<TaskId> assignedActiveTasks() {
        return this.assignedActiveTasks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<String, Set<TaskId>> assignedActiveTasksByMember() {
        return this.assignedActiveTasks;
    }

    public Set<TaskId> assignedStandbyTasks() {
        return this.assignedStandbyTasks.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<String, Set<TaskId>> assignedStandbyTasksByMember() {
        return this.assignedStandbyTasks;
    }

    public void addTask(String memberId, TaskId taskId, boolean isActive) {
        if (isActive) {
            this.assignedActiveTasks.putIfAbsent(memberId, new HashSet());
            this.assignedActiveTasks.get(memberId).add(taskId);
        } else {
            this.assignedStandbyTasks.putIfAbsent(memberId, new HashSet());
            this.assignedStandbyTasks.get(memberId).add(taskId);
        }
        this.memberToTaskCounts.put(memberId, this.memberToTaskCounts.get(memberId) + 1);
        this.computeLoad();
    }

    private void incrementCapacity() {
        ++this.capacity;
        this.computeLoad();
    }

    public void computeLoad() {
        this.load = this.capacity <= 0 ? -1.0 : (double)this.totalTaskCount() / (double)this.capacity;
    }

    public void addMember(String member) {
        this.memberToTaskCounts.put(member, 0);
        this.incrementCapacity();
    }

    public boolean hasCapacity() {
        return this.totalTaskCount() < this.capacity;
    }

    public int compareTo(ProcessState other) {
        int loadCompare = Double.compare(this.load, other.load());
        if (loadCompare == 0) {
            return Integer.compare(other.capacity, this.capacity);
        }
        return loadCompare;
    }

    public boolean hasTask(TaskId taskId) {
        return this.assignedActiveTasks().contains(taskId) || this.assignedStandbyTasks().contains(taskId);
    }

    Set<TaskId> assignedTasks() {
        Set<TaskId> assignedActiveTaskIds = this.assignedActiveTasks();
        Set<TaskId> assignedStandbyTaskIds = this.assignedStandbyTasks();
        return Collections.unmodifiableSet(Utils.union(() -> new HashSet(assignedActiveTaskIds.size() + assignedStandbyTaskIds.size()), (Set[])new Set[]{assignedActiveTaskIds, assignedStandbyTaskIds}));
    }
}

