/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum GroupState {
    UNKNOWN("Unknown"),
    PREPARING_REBALANCE("PreparingRebalance"),
    COMPLETING_REBALANCE("CompletingRebalance"),
    STABLE("Stable"),
    DEAD("Dead"),
    EMPTY("Empty"),
    ASSIGNING("Assigning"),
    RECONCILING("Reconciling"),
    NOT_READY("NotReady");

    private static final Map<String, GroupState> NAME_TO_ENUM;
    private final String name;

    private GroupState(String name) {
        this.name = name;
    }

    public static GroupState parse(String name) {
        GroupState state = NAME_TO_ENUM.get(name.toUpperCase(Locale.ROOT));
        return state == null ? UNKNOWN : state;
    }

    public static Set<GroupState> groupStatesForType(GroupType type) {
        if (type == GroupType.CLASSIC) {
            return Set.of(PREPARING_REBALANCE, COMPLETING_REBALANCE, STABLE, DEAD, EMPTY);
        }
        if (type == GroupType.CONSUMER) {
            return Set.of(PREPARING_REBALANCE, COMPLETING_REBALANCE, STABLE, DEAD, EMPTY, ASSIGNING, RECONCILING);
        }
        if (type == GroupType.STREAMS) {
            return Set.of(STABLE, DEAD, EMPTY, ASSIGNING, RECONCILING, NOT_READY);
        }
        if (type == GroupType.SHARE) {
            return Set.of(STABLE, DEAD, EMPTY);
        }
        throw new IllegalArgumentException("Group type not known");
    }

    public String toString() {
        return this.name;
    }

    static {
        NAME_TO_ENUM = Arrays.stream(GroupState.values()).collect(Collectors.toMap(state -> state.name.toUpperCase(Locale.ROOT), Function.identity()));
    }
}

