/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.util.Lst;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jspecview.api.JSVFileDropper;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.api.PanelListener;
import jspecview.application.AppToolBar;
import jspecview.application.ApplicationMenu;
import jspecview.application.AwtTree;
import jspecview.application.CommandHistory;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.JSpecView;
import jspecview.application.PreferencesDialog;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptToken;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.source.JDXSource;
import org.jmol.api.JSVInterface;

public class MainFrame
extends JFrame
implements PanelListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RECENT = 10;
    private static final int JMOL_MIN_HEIGHT = 130;
    JSViewer vwr;
    private JSpecView jsv;
    ApplicationMenu appMenu;
    private AppToolBar toolBar;
    private JTextField commandInput = new JTextField();
    private BorderLayout mainborderLayout = new BorderLayout();
    private JSplitPane mainSplitPane = new JSplitPane();
    private final JPanel nullPanel = new JPanel();
    private JSplitPane sideSplitPane = new JSplitPane();
    private CommandHistory commandHistory;
    private DisplaySchemesProcessor dsp;
    private Component jmolDisplay;
    private Dimension jmolDimensionOld;
    private JPanel jmolPanel;
    private Dimension jmolDimensionNew = new Dimension(350, 300);
    private Lst<String> recentFilePaths = new Lst();
    private JScrollPane spectraTreeScrollPane;
    private Component mainPanel;
    private JPanel statusPanel = new JPanel();
    private JLabel statusLabel = new JLabel();
    private AwtTree tree;
    private boolean sidePanelOn;
    private boolean showExitDialog;
    private boolean statusbarOn;
    private boolean toolbarOn;
    private int mainSplitPosition = 200;
    private int splitPosition;
    private boolean isHidden;
    private String tempDS;
    private boolean isAwake;
    private int jmolFrameHeight;
    private int jmolFrameWidth;

    public static void main(String[] stringArray) {
        JSpecView.main(stringArray);
    }

    public MainFrame(JSpecView jSpecView, Component component, JSVInterface jSVInterface) {
        this.jsv = jSpecView;
        this.vwr = jSpecView.vwr;
        this.jmolDisplay = component;
        if (component != null) {
            this.jmolPanel = (JPanel)component.getParent();
        }
        jSpecView.setStatusListener(jSVInterface);
        this.init();
    }

    void exitJSpecView(boolean bl, boolean bl2) {
        this.jsv.notifyExitingJspecView(bl2, bl && this.showExitDialog);
    }

    public void awaken(boolean bl) {
        if (!this.vwr.isEmbedded) {
            return;
        }
        System.out.println("MAINFRAME visible/awake" + bl + " " + this.isAwake + " " + this.jmolDisplay);
        if (this.isAwake == bl) {
            return;
        }
        this.jsv.vwr.setRecentSimulation(null);
        this.isAwake = bl;
        if (this.jmolDisplay != null) {
            try {
                Container container = this.jmolPanel.getTopLevelAncestor();
                if (bl) {
                    this.jmolDimensionOld = new Dimension(0, 0);
                    this.jmolDisplay.getSize(this.jmolDimensionOld);
                    this.jmolDisplay.setSize(this.jmolDimensionNew);
                    this.jmolPanel.remove(this.jmolDisplay);
                    if (container.getHeight() > 130) {
                        this.jmolFrameHeight = container.getHeight();
                        this.jmolFrameWidth = container.getWidth();
                        container.setSize(this.jmolFrameWidth, 130);
                    }
                    this.jmolPanel.add(this.nullPanel);
                    this.sideSplitPane.setBottomComponent(this.jmolDisplay);
                    this.sideSplitPane.setDividerLocation(this.splitPosition);
                    this.sideSplitPane.validate();
                    this.jmolPanel.validate();
                    System.out.println("awakened");
                } else {
                    this.sideSplitPane.setBottomComponent(this.nullPanel);
                    this.splitPosition = this.sideSplitPane.getDividerLocation();
                    this.jmolPanel.add(this.jmolDisplay);
                    if (container.getHeight() <= 130) {
                        container.setSize(this.jmolFrameWidth, this.jmolFrameHeight);
                    }
                    this.jmolDisplay.getSize(this.jmolDimensionNew);
                    this.jmolDisplay.setSize(this.jmolDimensionOld);
                    this.sideSplitPane.validate();
                    this.jmolPanel.validate();
                    System.out.println("sleeping");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setVisible(bl);
    }

    private void init() {
        DropTargetListener dropTargetListener = (DropTargetListener)this.vwr.getPlatformInterface("FileDropper");
        ((JSVFileDropper)((Object)dropTargetListener)).set(this.vwr);
        new DropTarget(this, dropTargetListener);
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("icons/spec16.gif");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        this.setApplicationProperties(true);
        this.tempDS = this.jsv.defaultDisplaySchemeName;
        this.tree = new AwtTree(this.vwr);
        this.vwr.spectraTree = this.tree;
        this.tree.setCellRenderer(new SpectraTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && MainFrame.this.vwr.selectedPanel != null) {
                    MainFrame.this.vwr.selectedPanel.getPanelData().setZoom(0.0, 0.0, 0.0, 0.0);
                    MainFrame.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        new DropTarget(this.tree, dropTargetListener);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setApplicationElements();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.windowClosing_actionPerformed();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                MainFrame.this.windowIconified_actionPerformed();
            }
        });
        this.setSize(1200, 800);
    }

    private void setApplicationElements() {
        this.appMenu.setSelections(this.sidePanelOn, this.toolbarOn, this.statusbarOn, this.vwr.selectedPanel);
        this.toolBar.setSelections(this.vwr.selectedPanel);
    }

    private void setApplicationProperties(boolean bl) {
        Properties properties = this.vwr.properties;
        String string = properties.getProperty("recentFilePaths");
        this.recentFilePaths.clear();
        if (!string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() >= 100) continue;
                this.recentFilePaths.addLast(string2);
            }
        }
        this.showExitDialog = Boolean.parseBoolean(properties.getProperty("confirmBeforeExit"));
        this.sidePanelOn = Boolean.parseBoolean(properties.getProperty("showSidePanel"));
        this.toolbarOn = Boolean.parseBoolean(properties.getProperty("showToolBar"));
        this.statusbarOn = Boolean.parseBoolean(properties.getProperty("showStatusBar"));
        this.jsv.setApplicationProperties(bl);
    }

    private void jbInit() throws Exception {
        this.toolBar = new AppToolBar(this);
        this.appMenu = new ApplicationMenu(this);
        this.appMenu.setRecentMenu(this.recentFilePaths);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.appMenu);
        this.setTitle("JSpecView");
        this.getContentPane().setLayout(this.mainborderLayout);
        this.sideSplitPane.setOrientation(0);
        this.sideSplitPane.setOneTouchExpandable(true);
        this.statusLabel.setToolTipText("");
        this.statusLabel.setHorizontalTextPosition(10);
        this.statusLabel.setText("  ");
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(2);
        borderLayout.setVgap(2);
        this.statusPanel.setLayout(borderLayout);
        this.mainSplitPane.setCursor(Cursor.getDefaultCursor());
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(0.3);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.commandInput, "South");
        this.commandHistory = new CommandHistory(this.vwr, this.commandInput);
        this.commandInput.setFocusTraversalKeysEnabled(false);
        this.commandInput.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                MainFrame.this.keyPressedEvent(keyEvent.getKeyCode(), keyEvent.getKeyChar());
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.spectraTreeScrollPane = new JScrollPane(this.tree);
        if (this.jmolDisplay != null) {
            JSplitPane jSplitPane = new JSplitPane();
            BorderLayout borderLayout2 = new BorderLayout();
            jSplitPane.setLayout(borderLayout2);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.BLACK);
            jSplitPane.add((Component)jPanel, "South");
            jSplitPane.add((Component)this.spectraTreeScrollPane, "North");
            this.sideSplitPane.setTopComponent(this.spectraTreeScrollPane);
            this.splitPosition = 300;
            this.sideSplitPane.setDividerLocation(300);
            this.awaken(true);
            this.mainSplitPane.setLeftComponent(this.sideSplitPane);
        } else {
            this.mainSplitPane.setLeftComponent(this.spectraTreeScrollPane);
        }
        this.mainPanel = (Component)((Object)this.vwr.mainPanel);
        this.mainSplitPane.setRightComponent(this.mainPanel);
    }

    protected void keyPressedEvent(int n, char c) {
        this.commandHistory.keyPressed(n);
        String string = this.vwr.checkCommandLineForTip(c, this.commandInput.getText(), true);
        if (string != null) {
            this.commandInput.setText(string);
        }
        this.commandInput.requestFocusInWindow();
    }

    void setError(boolean bl, boolean bl2) {
        this.appMenu.setError(bl, bl2);
        this.toolBar.setError(bl, bl2);
    }

    void showNotImplementedOptionPane() {
        if (this.vwr.hasDisplay) {
            JOptionPane.showMessageDialog(this, "Not Yet Implemented", "Not Yet Implemented", 1);
        }
    }

    @Override
    public void panelEvent(Object object) {
        SubSpecChangeEvent subSpecChangeEvent;
        if (object instanceof PeakPickEvent) {
            this.vwr.processPeakPickEvent(object, true);
        } else if (object instanceof ZoomEvent) {
            this.writeStatus("Double-Click highlighted spectrum in menu to zoom out; CTRL+/CTRL- to adjust Y scaling.");
        } else if (object instanceof SubSpecChangeEvent && !(subSpecChangeEvent = (SubSpecChangeEvent)object).isValid()) {
            this.vwr.advanceSpectrumBy(-subSpecChangeEvent.getSubIndex());
        }
    }

    void setSplitPane(boolean bl) {
        if (bl) {
            this.mainSplitPane.setDividerLocation(200);
        } else {
            this.mainSplitPane.setDividerLocation(0);
        }
    }

    void enableToolbar(boolean bl) {
        if (bl) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.validate();
    }

    void showPreferences() {
        PreferencesDialog preferencesDialog = new PreferencesDialog(this, this.vwr, "Preferences", true, this.dsp);
        this.vwr.properties = preferencesDialog.getPreferences();
        boolean bl = preferencesDialog.shouldApplySpectrumDisplaySettingsNow();
        this.setApplicationProperties(bl);
        int n = this.vwr.panelNodes.size();
        while (--n >= 0) {
            this.jsv.siSetPropertiesFromPreferences(((PanelNode)this.vwr.panelNodes.get((int)n)).jsvp, bl);
        }
        this.setApplicationElements();
        this.dsp.getDisplaySchemes();
        if (this.jsv.defaultDisplaySchemeName.equals("Current")) {
            this.vwr.setProperty("defaultDisplaySchemeName", this.tempDS);
        }
    }

    void exportSpectrumViaMenu(String string) {
        new Exporter().write(this.vwr, ScriptToken.getTokens(string), false);
    }

    void enableStatus(boolean bl) {
        if (bl) {
            this.getContentPane().add((Component)this.statusPanel, "South");
        } else {
            this.getContentPane().remove(this.statusPanel);
        }
        this.validate();
    }

    protected void windowClosing_actionPerformed() {
        this.exitJSpecView(true, true);
    }

    protected void windowIconified_actionPerformed() {
        if (this.jsv.jmol == null) {
            return;
        }
        this.setState(0);
        this.isHidden = true;
        this.setVisible(!this.isHidden);
        this.exitJSpecView(false, false);
    }

    void updateToolbar(ScriptToken scriptToken, boolean bl) {
        if (this.vwr.selectedPanel != null) {
            switch (scriptToken) {
                case COORDINATESON: {
                    this.toolBar.coordsToggleButton.setSelected(bl);
                    break;
                }
                case GRIDON: {
                    this.toolBar.gridToggleButton.setSelected(bl);
                    break;
                }
            }
        }
    }

    void sourceClosed(JDXSource jDXSource) {
        this.appMenu.clearSourceMenu(jDXSource);
        this.setTitle("JSpecView");
        this.validateAndRepaint(false);
    }

    void setLoading(String string, String string2) {
        this.appMenu.setCloseMenuItem(string);
        this.setTitle("JSpecView - " + (string2.startsWith("http://SIMULATION/") ? String.valueOf(JSVFileManager.getSimulationType(string2)) + " SIMULATION" : string2));
        this.appMenu.setSourceEnabled(true);
    }

    void updateRecentMenus(String string) {
        if (string.length() > 100) {
            return;
        }
        if (this.recentFilePaths.size() >= 10) {
            this.recentFilePaths.removeItemAt(9);
        }
        if (this.recentFilePaths.contains(string)) {
            this.recentFilePaths.removeObj(string);
        }
        this.recentFilePaths.add(0, string);
        SB sB = new SB();
        int n = this.recentFilePaths.size();
        int n2 = 0;
        while (n2 < n) {
            sB.append(", ").append((String)this.recentFilePaths.get(n2));
            ++n2;
        }
        this.vwr.setProperty("recentFilePaths", n == 0 ? "" : sB.substring(2));
        this.appMenu.updateRecentMenus(this.recentFilePaths);
    }

    void setMenuEnables(PanelNode panelNode, boolean bl) {
        this.appMenu.setMenuEnables(panelNode);
        this.toolBar.setMenuEnables(panelNode);
    }

    void setSelectedPanel(JSVPanel jSVPanel) {
        if (this.vwr.selectedPanel != null) {
            this.mainSplitPosition = this.mainSplitPane.getDividerLocation();
        }
        this.vwr.mainPanel.setSelectedPanel(this.vwr, jSVPanel, this.vwr.panelNodes);
        this.vwr.spectraTree.setSelectedPanel(this.jsv, jSVPanel);
        this.validate();
        if (jSVPanel != null) {
            jSVPanel.setEnabled(true);
            jSVPanel.setFocusable(true);
        }
        if (this.mainSplitPosition != 0) {
            this.mainSplitPane.setDividerLocation(this.mainSplitPosition);
        }
    }

    void validateAndRepaint(boolean bl) {
        this.validate();
        if (bl) {
            this.repaint();
        } else {
            this.vwr.requestRepaint();
        }
    }

    void execHidden(boolean bl) {
        this.isHidden = this.jsv.jmol != null && bl;
        this.setVisible(!this.isHidden);
    }

    void writeStatus(String string) {
        if (string == null) {
            string = "Unexpected Error";
        }
        if (string.length() == 0) {
            string = "Enter a command:";
        }
        this.statusLabel.setText(string);
    }

    void setTreeEnabled(boolean bl) {
        this.tree.setEnabled(bl);
    }

    void closeMenuItem(JDXSource jDXSource) {
        if (jDXSource != null) {
            this.appMenu.setCloseMenuItem(JSVFileManager.getTagName(jDXSource.getFilePath()));
        }
        boolean bl = jDXSource != null && jDXSource.getErrorLog().length() > 0;
        this.setError(bl, bl && jDXSource.getErrorLog().indexOf("Warning") >= 0);
    }

    private class SpectraTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JSVTreeNode node;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.node = (JSVTreeNode)object;
            return this;
        }

        @Override
        public Font getFont() {
            return new Font("Dialog", this.node == null || this.node.getPanelNode() == null || this.node.getPanelNode().jsvp == null ? 1 : 2, 12);
        }
    }
}

