/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.AU;
import javajs.util.DF;
import javajs.util.Lst;
import jspecview.api.AnnotationData;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.Measurement;
import jspecview.common.Parameters;
import jspecview.common.Spectrum;

public class MeasurementData
extends Lst<Measurement>
implements AnnotationData {
    private static final long serialVersionUID = 1L;
    private Annotation.AType type;
    protected Spectrum spec;
    protected String units;
    protected int precision;
    protected Parameters myParams;
    private boolean isON = true;
    private String key;
    private static final String[] HEADER = new String[]{"", "start", "end", "value"};

    MeasurementData(Annotation.AType type, Spectrum spec) {
        this.type = type;
        this.spec = spec;
        this.myParams = new Parameters().setName("MeasurementData");
    }

    Lst<Measurement> getMeasurements() {
        return this;
    }

    @Override
    public Annotation.AType getAType() {
        return this.type;
    }

    @Override
    public boolean getState() {
        return this.isON;
    }

    @Override
    public void setState(boolean b) {
        this.isON = b;
    }

    void setMeasurements(Lst<Measurement> measurements) {
    }

    @Override
    public Parameters getParameters() {
        return this.myParams;
    }

    public String[] getDataHeader() {
        return HEADER;
    }

    public String[][] getMeasurementListArray(String units) {
        this.units = units;
        double[][] ddata = this.getMeasurementListArrayReal(units);
        int precisionX = this.spec.isNMR() ? 4 : 2;
        int precisionDX = this.spec.isHNMR() && units.equals("ppm") ? 4 : 2;
        String[][] data = new String[this.size()][];
        int i = this.size();
        while (--i >= 0) {
            data[i] = new String[]{"" + (i + 1), DF.formatDecimalDbl(ddata[i][0], precisionX), DF.formatDecimalDbl(ddata[i][1], precisionX), DF.formatDecimalDbl(ddata[i][2], precisionDX)};
        }
        return data;
    }

    double[][] getMeasurementListArrayReal(String units) {
        boolean toHz = this.spec.isNMR() && units.equalsIgnoreCase("HZ");
        double[][] data = AU.newDouble2(this.size());
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            double y = ((Measurement)this.get(i)).getValue();
            if (toHz) {
                y *= this.spec.getObservedFreq();
            }
            data[pt++] = new double[]{((Measurement)this.get(i)).getXVal(), ((Measurement)this.get(i)).getXVal2(), y};
        }
        return data;
    }

    static boolean checkParameters(MeasurementData md, ColorParameters p) {
        if (md.size() == 0) {
            return false;
        }
        Parameters myParams = md.getParameters();
        switch (md.getAType()) {
            case Integration: {
                break;
            }
            case PeakList: {
                return p.peakListInterpolation.equals(myParams.peakListInterpolation) && p.peakListThreshold == myParams.peakListThreshold;
            }
            case Measurements: {
                break;
            }
        }
        return false;
    }

    @Override
    public Spectrum getSpectrum() {
        return this.spec;
    }

    @Override
    public MeasurementData getData() {
        return this;
    }

    protected void clear(double x1, double x2) {
        int i = this.size();
        while (--i >= 0) {
            Measurement in = (Measurement)this.get(i);
            if (in.text.length() != 0 && !in.overlaps(x1, x2)) continue;
            this.removeItemAt(i);
        }
    }

    protected int find(double x) {
        int i = this.size();
        while (--i >= 0) {
            Measurement in = (Measurement)this.get(i);
            if (!in.overlaps(x, x)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setSpecShift(double dx) {
        int i = this.size();
        while (--i >= 0) {
            Measurement m = (Measurement)this.get(i);
            double x = m.getXVal() + dx;
            m.setXVal(x);
            m.setValue(x);
            m.text = DF.formatDecimalDbl(x, this.precision);
        }
    }

    @Override
    public String getGraphSetKey() {
        return this.key;
    }

    @Override
    public void setGraphSetKey(String key) {
        this.key = key;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    void getInfo(Map<String, Object> info) {
        info.put("header", this.getDataHeader());
        info.put("table", this.getMeasurementListArrayReal("ppm"));
        if (this.units != null) {
            info.put("units", this.units);
        }
    }

    @Override
    public boolean isDialog() {
        return false;
    }
}

