<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output indent="yes" method="xml" />
  <xsl:template match="/">
    <bag>
      <vectorQuery id="GETopDown">
        <derivedQuery id="BigCoreGroup" displayName="%BigCoreGroup">
          <valueEval>$NULL</valueEval>
          <displayAttributes>
              <boolean:expand>true</boolean:expand>
              <boolean:allowCollapse>false</boolean:allowCollapse>
          </displayAttributes>
          <expand>
            <vectorQuery id="BigCoreGroupExpanded">
              <vectorQueryInsert>/GETopDown_big</vectorQueryInsert>
            </vectorQuery>
          </expand>
        </derivedQuery>
        <derivedQuery id="SmallCoreGroup" displayName="%SmallCoreGroup">
          <valueEval>$NULL</valueEval>
          <displayAttributes>
              <boolean:expand>true</boolean:expand>
              <boolean:allowCollapse>false</boolean:allowCollapse>
          </displayAttributes>
          <expand>
            <vectorQuery id="SmallCoreGroupExpanded">
              <vectorQueryInsert>/GETopDown_small</vectorQueryInsert>
            </vectorQuery>
          </expand>
        </derivedQuery>
      </vectorQuery>
      <vectorQuery id="locatorGETopDown">
        <derivedQuery id="BigCoreGroup" displayName="%BigCoreGroup">
          <valueEval>$NULL</valueEval>
          <displayAttributes>
              <boolean:expand>true</boolean:expand>
              <boolean:allowCollapse>false</boolean:allowCollapse>
          </displayAttributes>
          <expand>
            <vectorQuery id="BigCoreGroupExpanded">
              <vectorQueryInsert>/locatorGETopDown_big</vectorQueryInsert>
            </vectorQuery>
          </expand>
        </derivedQuery>
        <derivedQuery id="SmallCoreGroup" displayName="%SmallCoreGroup">
          <valueEval>$NULL</valueEval>
          <displayAttributes>
              <boolean:expand>true</boolean:expand>
              <boolean:allowCollapse>false</boolean:allowCollapse>
          </displayAttributes>
          <expand>
            <vectorQuery id="SmallCoreGroupExpanded">
              <vectorQueryInsert>/locatorGETopDown_small</vectorQueryInsert>
            </vectorQuery>
          </expand>
        </derivedQuery>
      </vectorQuery>
      <queryLibrary>
        <xsl:variable name="tmamQueryFileBig" select="document('config://include/queries_tmam_4_302/glc_big.xsl')"/>
        <xsl:variable name="tmamQueryFileSmall" select="document('config://include/queries_tmam_4_302/grt_small.xsl')"/>
        <xsl:copy-of select="$tmamQueryFileBig//bag/queryLibrary/*"/>
        <xsl:copy-of select="$tmamQueryFileBig//bag/locatorqueryLibrary/*"/>
        <xsl:copy-of select="$tmamQueryFileSmall//bag/queryLibrary/*"/>
        <xsl:copy-of select="$tmamQueryFileSmall//bag/locatorqueryLibrary/*"/>
        <xsl:copy-of select="$tmamQueryFileBig//bag/vectorQuery"/>
        <xsl:copy-of select="$tmamQueryFileSmall//bag/vectorQuery"/>
        <derivedQuery displayName="%SLOTS" id="SLOTS">
          <description>%SLOTSDescriptionAll</description>
          <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
          <valueEval>
              <![CDATA[ query("/SLOTS_big") + query("/SLOTS_small") ]]></valueEval>
        </derivedQuery>
        <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots">
          <queryInherit>/GeMetricBaseSlots</queryInherit>
          <description>%RetiredPipelineSlotsDescriptionAll</description>
          <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
          <valueEval>
              <![CDATA[ ( ( query("/RetiredPipelineSlots_small") * query("/SLOTS_small") ) + ( query("/RetiredPipelineSlots_big") * query("/SLOTS_big") ) ) / ( query("/SLOTS") ) ]]></valueEval>
          <confidenceEval>
              <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[P-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
        </derivedQuery>
      </queryLibrary>
    </bag>
  </xsl:template>
</xsl:stylesheet>
