"use strict";angular.module("filterbar",["ui-session","services","loading","ngRoute"],["$routeProvider",e=>{e.when("/qfilter/:identity",{template:'<div class="filterbar" ng-class="{ \'separate-browser\': separateBrowser }" data-tour-item="filterbarTourItem"><div class="title">{{::filterLabel}}</div><icon class="icon" ng-class="{loading: loading.isInProgress() || saving.isInProgress()}" percentage="metrics.selected.filterPercentage"></icon><div class="filter-percentage" ng-if="hasMetrics() && percentagesUpdated" ng-show="isInitialized()">{{metrics.selected.filterPercentage | number : 1}}%</div><div class="slider" ng-if="hasMetrics()"><span class="of">{{::ofLabel}}</span><div class="metrics" title="{{::metricTooltip}}"><select class="dropdown" ng-model="metrics.selected" ng-options="metric as metric.name for metric in metrics | filter:{applicable:true}"></select></div></div><clear-filter ng-click="clearFilter()" class="clear-filter" disabled="isFilterEmpty || loading.isInProgress() || saving.isInProgress()" title="{{::clearFilterTooltip}}"></clear-filter><div class="separator" ng-if="hasMetrics() && filters.length > 0" ng-show="isInitialized()"></div><z-filter ng-repeat="filter in filters track by filter.grouping" ng-if="hasMetrics()" config="filter" filters="filters" is-initialized="isInitialized()" metrics="metrics" loading="::loading" saving="::saving" selected-metric="metrics.selected" value-type="valueType"></z-filter><div class="separator" ng-if="config.knobs.length > 0" ng-show="isInitialized()"></div><knob ng-repeat="knob in config.knobs track by knob.id" config="knob" is-initialized="isInitialized()" loading="::loading" saving="::saving"></knob></div><filter-bar-test-harness-dump pane-id="paneId" results="config.results"></filter-bar-test-harness-dump>',controller:"FilterbarController"})}]);
"use strict";angular.module("filterbar").directive("filterBar",function(){return{restrict:"E",scope:{paneId:"="},template:'<div class="filterbar" ng-class="{ \'separate-browser\': separateBrowser }" data-tour-item="filterbarTourItem"><div class="title">{{::filterLabel}}</div><icon class="icon" ng-class="{loading: loading.isInProgress() || saving.isInProgress()}" percentage="metrics.selected.filterPercentage"></icon><div class="filter-percentage" ng-if="hasMetrics() && percentagesUpdated" ng-show="isInitialized()">{{metrics.selected.filterPercentage | number : 1}}%</div><div class="slider" ng-if="hasMetrics()"><span class="of">{{::ofLabel}}</span><div class="metrics" title="{{::metricTooltip}}"><select class="dropdown" ng-model="metrics.selected" ng-options="metric as metric.name for metric in metrics | filter:{applicable:true}"></select></div></div><clear-filter ng-click="clearFilter()" class="clear-filter" disabled="isFilterEmpty || loading.isInProgress() || saving.isInProgress()" title="{{::clearFilterTooltip}}"></clear-filter><div class="separator" ng-if="hasMetrics() && filters.length > 0" ng-show="isInitialized()"></div><z-filter ng-repeat="filter in filters track by filter.grouping" ng-if="hasMetrics()" config="filter" filters="filters" is-initialized="isInitialized()" metrics="metrics" loading="::loading" saving="::saving" selected-metric="metrics.selected" value-type="valueType"></z-filter><div class="separator" ng-if="config.knobs.length > 0" ng-show="isInitialized()"></div><knob ng-repeat="knob in config.knobs track by knob.id" config="knob" is-initialized="isInitialized()" loading="::loading" saving="::saving"></knob></div><filter-bar-test-harness-dump pane-id="paneId" results="config.results"></filter-bar-test-harness-dump>',controller:"FilterbarController"}});
"use strict";angular.module("filterbar").controller("FilterbarController",["$scope","$http","requestIdentity","$q","uiSession","error","grid","messages","Tracker",function(e,t,n,i,r,o,a,l,s){const c=i.defer(),u=e.loading=new s,f=e.saving=new s;function d(){const n=e.paneId?"api/viewpoint/config":"api/configuration";return t.get(n,{params:p({paneId:e.paneId})})}function p(t){return(t=t||{}).identity=n.get(e),t}function g(t){e.config=t.data,e.paneId=e.paneId||(e.config.pane||{}).id,e.messages=e.config.messages,e.ofLabel=l.get("ofLabel",e),e.metricTooltip=l.get("metricTooltip",e),e.clearFilterTooltip=l.get("clearFilterTooltip",e),e.filterLabel=l.get("filterLabel",e),e.config.data&&e.config.data.columns&&e.config.data.columns.length>0?u.start().then(m).then(a.validateResponse).then(a.sliceTotalColumn).then(a.checkColumnCount(1,!0)).then(a.checkRowCount(1,!1)).catch(function(t){return e.noMetrics=!0,i.reject(t)}).then(h).then(v).then(y).then(b).then(I).then(u.stop).catch(o.handle(e,u)):e.metrics=void 0}function m(){return t.get("api/grid",{params:p({columns:e.config.data.columns,expandColumns:!1}),timeout:c.promise})}function h(t){e.diffMode=t.columns[0]&&t.columns[0].result1Index&&t.columns[0].result2Index,e.valueType=e.diffMode?"value":"objectId",e.metrics=t.columns.filter(function(n){return n.canBeDoi&&(e.diffMode?t.rows[0].cells[n.result1Index-1].value||t.rows[0].cells[n.result2Index-1].value:t.rows[0].cells[n.index-1].value)}).map(function(n){return{id:n.id,originalValue:e.diffMode?t.rows[0].cells[n.result1Index-1].value+t.rows[0].cells[n.result2Index-1].value:t.rows[0].cells[n.index-1].value,filterPercentage:100,query:"/"+n.id,name:n.name,applicable:!0}}),e.metrics.by={},e.metrics.forEach(function(t){e.metrics.by[t.id]=t}),e.metrics.length>0?(e.metrics.selected=e.metrics[0],e.percentagesUpdated=!1):delete e.metrics}function v(){return t.get("api/filter",{params:p({name:"global"})})}function y(t){e.isFilterEmpty=t.data.isEmpty}function I(){function n(){f.start().then(function(){t.post("api/filter",{valueType:e.diffMode?"value":"objectId",and:e.filters.filter(function(e){return void 0!==e.value}).map(function(e){return{grouping:e.grouping,row:e.value}})},{params:p({source:"filterbar"}),timeout:c.promise})}).catch(o.logAndIgnore).finally(f.stop)}e.config.data&&e.config.data.groupings&&(e.filters=e.config.data.groupings.map(function(e){return{grouping:e,value:void 0,onChange:n}}))}function b(){if(!e.isFilterEmpty)return w();e.percentagesUpdated=!0}function w(){if(e.metrics)return u.start().then(x).then(a.validateResponse).then(a.sliceTotalColumn).then(a.checkColumnCount(1,!0)).then(a.checkRowCount(1,!1)).then(C).catch(o.logAndIgnore).finally(u.stop)}function x(){return t.get("api/grid",{params:p({columns:e.metrics.map(function(e){return e.query}),expandColumns:!1,filter:"global"}),timeout:c.promise})}function C(t){t.columns.forEach(function(n){const i=e.metrics.by[n.id];if(void 0===i)return;const r=e.diffMode?t.rows[0].cells[n.result1Index-1].value+t.rows[0].cells[n.result2Index-1].value:t.rows[0].cells[n.index-1].value;i.filterPercentage=r/i.originalValue*100,i.applicable=!0}),e.percentagesUpdated=!0}function E(){e.filters.forEach(e=>{e.value=void 0})}e.isFilterEmpty=!0,e.separateBrowser=!e.paneId,r.getPartitionSocket(e).then(function(){u.start().then(d).then(g).then(u.stop).catch(o.handle(e,u))}),e.$on("result:filter:changed",(t,n)=>{w(),e.isFilterEmpty=n.filter.isEmpty,e.isFilterEmpty&&E()}),e.clearFilter=function(){e.isFilterEmpty||u.isInProgress()||f.isInProgress()||(e.isFilterEmpty=!0,f.start().then(function(){t.post("api/filter",{to:"global"},{params:p(),timeout:c.promise})}).then(E).catch(o.logAndIgnore).finally(f.stop))},e.hasMetrics=function(){return e.metrics&&e.metrics.length>0&&e.metrics.some(function(e){return e.applicable})},e.$on("$destroy",()=>{c.resolve(),u.destroy()}),e.isInitialized=function(){return!!e.config&&((!e.config.data.groupings||e.noMetrics||e.filters&&Array.isArray(e.filters)&&(e.filters.every(t)||!e.hasMetrics()))&&(!e.config.knobs||Array.isArray(e.config.knobs)&&e.config.knobs.every(t)));function t(e){return e.initialized}}}]);
"use strict";angular.module("filterbar").directive("clearFilter",function(){return{restrict:"E",replace:!0,scope:{disabled:"="},template:'<div class="clear-filter"><svg ng-class="{disabled: disabled}" viewBox="0 0 20 20"><g transform="translate(10, 10)"><path class="funnel" d="M -6,-5 L 6,-5 6,-4 1.5,.5 1.5,7 -1.5,5 -1.5,.5 -6,-4 Z"></path><g transform="translate(5, 5)"><path class="cross" d="M-3,-5 L 0,-2 3,-5 5,-3 2,0 5,3 3,5 0 2 -3,5 -5,3 -2,0 -5,-3 Z"></path></g></g></svg></div>'}});
"use strict";angular.module("filterbar").controller("FilterController",["$scope","$http","requestIdentity","$q","uiSession","error","grid","messages","Tracker",function(e,t,n,l,i,r,o,c,a){const s=l.defer(),u=new a;let d;i.getPartitionSocket(e).then(function(e){e.on("FilterChangedEvent",()=>{g()})}),e.$on("result:filter:changed",()=>{g()});const f=e.$watch("selectedMetric",function(){e.selectedMetric&&(e.items?y(e.items):g().finally(()=>{e.config.initialized=!0}))});function g(){return d=void 0,e.loading.start().then(u.start).then(p).then(o.validateResponse).then(h).then(b).then(y).finally(u.stop).then(u.waitToComplete).then(m).catch(r.logAndIgnore).finally(e.loading.stop)}function m(){e.items=d}function p(){return t.get("api/grid",{params:{identity:n.get(e),columns:e.metrics.map(e=>e.query),expandColumns:!1,grouping:e.config.grouping,filter:JSON.stringify(v()),paneId:e.paneId},timeout:s.promise})}function v(){const t=e.filters.filter(function(e){return void 0!==e.value}).filter(function(t){return t.grouping!==e.config.grouping}).map(function(e){return{grouping:e.grouping,row:e.value}}),n={reference:"global-not-from-filterbar"};return t.length>0?{valueType:e.valueType,and:t.concat(n)}:n}function h(t){return t.columns&&t.rows?t:(e.metrics.forEach(e=>{e.applicable=!1}),l.reject("Empty data"))}function b(t){if(e.label=t.columns[0].name,e.label&&(e.tooltip=c.get("selectLabel",e)+" "+e.label.toLowerCase()+" "+c.get("tooltip2dPartLabel",e)),e.diffMode=t.columns[1]&&t.columns[1].result1Index&&t.columns[1].result2Index,e.metrics.forEach(function(e){(function(e,t){return t.some(t=>e.id===t.id)})(e,t.columns)||(e.applicable=!1)}),!0!==e.selectedMetric.applicable){const t=e.metrics.filter(e=>e.applicable);t.length>0&&(e.metrics.selected=t[0],e.selectedMetric.id=t[0].id)}return(d=t.rows.map(function(l){return{value:e.diffMode?l.cells[0].valueInternal:l.cells[0].objectId,metrics:n(l,t.columns)}})).push({value:void 0,metrics:e.metrics.reduce(function(t,n){return t[n.id]={value:Number.MAX_VALUE,label:c.get("any",e)+" "+e.label},t},{})}),d;function n(t,n){const[{aliasForUnknown:l}]=n,i={};for(let o=1;o<n.length;o++){const c=e.metrics.by[n[o].id];if(!c)continue;const a=e.diffMode?t.cells[n[o].result1Index-1].value+t.cells[n[o].result2Index-1].value:t.cells[n[o].index-1].value,s=t.cells[0].formattedValue||l;i[c.id]={value:a,label:"["+(r=a/c.originalValue,(100*r).toFixed(1)+"%")+"] "+s}}var r;return i}}function y(t){e.selectedMetric&&t.sort((t,n)=>n.metrics[e.selectedMetric.id].value-t.metrics[e.selectedMetric.id].value)}e.$on("$destroy",()=>{f&&f(),s.resolve(),e.loading.destroy()})}]);
"use strict";angular.module("filterbar").directive("zFilter",function(){return{restrict:"E",replace:!0,scope:{config:"=",selectedMetric:"=",metrics:"=",valueType:"=",filters:"=",isInitialized:"&",loading:"=",saving:"="},template:'<div class="filter" ng-show="isInitialized() && items" title="{{tooltip}}"><div class="label">{{::label}}</div><select class="dropdown" ng-model="config.value" ng-change="config.onChange()" ng-disabled="loading.isInProgress() || saving.isInProgress()" ng-options="item.value as item.metrics[selectedMetric.id].label for item in items"></select></div>',controller:"FilterController"}});
"use strict";angular.module("filterbar").controller("KnobController",["$scope","$http","requestIdentity","$q","uiSession","error",function(n,t,o,e,i,a){const r=e.defer();function s(){return t.get("api/knob",{params:{identity:o.get(n),knobId:n.config.id,paneId:n.paneId},timeout:r.promise})}function d(t){n.knob=t.data.knob}function c(){return t.post("api/knob",n.knob,{params:{identity:o.get(n),paneId:n.paneId},timeout:r.promise})}i.getPartitionSocket(n).then(function(){n.loading.start().then(s).then(d).catch(a.logAndIgnore).finally(()=>{n.loading.stop(),n.config.initialized=!0})}),n.knobChanged=function(){n.saving.start().then(c).catch(a.logAndIgnore).finally(n.saving.stop)},n.$on("$destroy",()=>{r.resolve()})}]);
"use strict";angular.module("filterbar").directive("knob",function(){return{restrict:"E",replace:!0,scope:{config:"=",isInitialized:"&",loading:"=",saving:"="},template:'<div class="knob" ng-show="knob.item && isInitialized()"><div class="label">{{knob.name}}</div><select class="dropdown" ng-model="knob.value" ng-options="item.value as item._ for item in knob.item" ng-change="knobChanged()" ng-disabled="loading.isInProgress() || saving.isInProgress()" title="{{knob.description}}"></select></div>',controller:"KnobController"}});
"use strict";angular.module("filterbar").directive("filterBarTestHarnessDump",["$timeout","$q","$interval","dumpHelper","dumpDispatcher",function(e,t,n,r,i){return{restrict:"E",scope:{paneId:"=",results:"="},link:function(a){const{paneId:o}=a;function s(e){const t="/test-harness/action?type="+e+"&paneId="+o;return{type:e,items:$(".filterbar").find("."+e+":not(.ng-hide)").map(function(e,n){const r=$(n).find("select").val();return{name:$(n).find(".label").text(),items:$(n).find("select option").map(function(n){return{value:$(this).text(),selected:$(this).val()===r,select:{href:t+"&dropdown="+e+"&option="+n}}}).get()}}).get()}}function c(){return{clear:"/test-harness/action?paneId="+o+"&type="+"clear"}}i.addDumpListener({paneId:o,$scope:a},async function(r){try{return r&&r.afterRefresh&&await function(){const r=t.defer(),i=n(()=>{$(".icon").hasClass("loading")&&(r.resolve(),n.cancel(i))},200);return e(function(){n.cancel(i),r.reject("Timeout on waiting for loading to start.")},6e4),r.promise}(),await function(){const r=t.defer(),i=n(()=>{$(".icon").hasClass("loading")||(r.resolve(),n.cancel(i))},500);return e(function(){n.cancel(i),r.reject("Timeout on waiting for loading to complete.")},6e4),r.promise}(),{paneId:o,result:a.results,dump:{filters:s("filter"),knobs:s("knob"),percentage:$(".filter-percentage").text(),controls:c(),clearFilterEnabled:0===$(".clear-filter .disabled").length}}}catch(e){return{paneId:o,result:a.results,dump:{message:e.message||e,stack:e.stack}}}}),i.addActionListener({paneId:o,$scope:a},async function(e){if("filter"===e.type||"knob"===e.type){const t="filter"===e.type?".filter":".knob",n=Number(e.option),i=Number(e.dropdown),a=$(".filterbar").find(t)[i],o=$(a).find("select");return r.chooseOptionFromNativeSelector(o,n)}if("clear"===e.type){const e=$(".clear-filter");return r.dispatchElementMouseEvent("click",e)}})}}}]);
"use strict";angular.module("filterbar").directive("icon",function(){const t=window.d3_main||window.d3;return{restrict:"E",replace:!0,scope:{percentage:"="},link:function(a,e){const n=t.select(e[0]).append("svg").attr("viewBox","0 0 20 20").append("g").attr("transform","translate(10, 10)"),r=t.arc().outerRadius(9.5).innerRadius(0);let s=[{value:0,class:"filtered-out"},{value:100,class:"no-filter"}];const c=t.pie().sort(null).value(t=>t.value);n.selectAll(".arc").data(c(s)).enter().append("g").attr("class","arc").append("path").attr("d",r).attr("class",t=>t.data.class),n.append("path").attr("class","funnel").attr("d","M -6 -5 L 6,-5 6,-4 1.5,.5 1.5,7 -1.5,5 -1.5,.5 -6,-4 Z"),n.append("path").attr("class","spinner").attr("d","M 0,-8.5 a 8.5,8.5 0 1 0 8.5,8.5");const l=a.$watch("percentage",function(){void 0!==a.percentage&&(s=[{value:100-a.percentage,class:"filtered-out"},{value:a.percentage,class:Math.round(10*a.percentage)/10==100?"no-filter":"left"}],n.selectAll(".arc").data(c(s)).select("path").attr("d",r).attr("class",t=>t.data.class))});a.$on("$destroy",function(){l&&l()})}}});
//# sourceMappingURL=perffilterbar-629235.js.map
