<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown_big" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="Light_OperationsGroup">
                                <queryInherit>/Light_Operations_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Light_OperationsGroupExpanded">
                                        <derivedQuery id="FP_ArithGroup">
                                            <queryInherit>/FP_Arith_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="FP_ArithGroupExpanded">
                                                    <queryRef>/FP_x87_big</queryRef>
                                                    <queryRef>/FP_Scalar_big</queryRef>
                                                    <queryRef>/FP_Vector_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/OTHER_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="Heavy_OperationsGroup">
                                <queryInherit>/Heavy_Operations_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Heavy_OperationsGroupExpanded">
                                        <derivedQuery id="MicroSequencerGroup">
                                            <queryInherit>/MicroSequencer_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MicroSequencerGroupExpanded">
                                                    <queryRef>/Assists_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>/FELatency_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>/ICacheMisses_big</queryRef>
                                        <queryRef>/ITLBOverhead_big</queryRef>
                                        <derivedQuery id="BranchResteersGroup">
                                            <queryInherit>/BranchResteers_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="BranchResteersGroupExpanded">
                                                    <queryRef>/Mispredicts_Resteers_big</queryRef>
                                                    <queryRef>/Clears_Resteers_big</queryRef>
                                                    <queryRef>/Unknown_Branches_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/DSBtoMITESwitchCost_big</queryRef>
                                        <queryRef>/LCP_big</queryRef>
                                        <queryRef>/MSSwitches_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>/FEBandwidth_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthMITE_big</queryRef>
                                        <queryRef>/FEBandwidthDSB_big</queryRef>
                                        <queryRef>/FEBandwidthLSD_big</queryRef>
                                        <queryRef>/DSB_Coverage_big</queryRef>
                                        <queryRef>/LSD_Coverage_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <queryRef>/BranchMispredict_big</queryRef>
                            <queryRef>/MachineClears_big</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound_big</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>/MemBound_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <derivedQuery id="L1BoundGroup">
                                            <queryInherit>/L1Bound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L1BoundGroupExpanded">
                                                    <derivedQuery id="DTLBOverheadGroup">
                                                        <queryInherit>/DTLBOverhead_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="DTLBOverheadGroupExpanded">
                                                                <queryRef>/Load_STLB_Hit_big</queryRef>
                                                                <queryRef>/Load_STLB_Miss_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/LoadsBlockedbyStoreForwarding_big</queryRef>
                                                    <queryRef>/LockLatency_big</queryRef>
                                                    <queryRef>/SplitLoads_big</queryRef>
                                                    <queryRef>/4KAliasing_big</queryRef>
                                                    <queryRef>/FBFull_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/L2Bound_big</queryRef>
                                        <derivedQuery id="L3BoundGroup">
                                            <queryInherit>/L3Bound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L3BoundGroupExpanded">
                                                    <queryRef>/ContestedAccesses_big</queryRef>
                                                    <queryRef>/DataSharing_big</queryRef>
                                                    <queryRef>/L3Latency_big</queryRef>
                                                    <queryRef>/SQFull_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="DRAMBoundGroup">
                                            <queryInherit>/DRAMBound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="DRAMBoundGroupExpanded">
                                                    <queryRef>/MEMBandwidth_big</queryRef>
                                                    <derivedQuery id="MEMLatencyGroup">
                                                        <queryInherit>/MEMLatency_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="MEMLatencyGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="StoresBoundGroup">
                                            <queryInherit>/StoresBound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="StoresBoundGroupExpanded">
                                                    <queryRef>/StoreLatency_big</queryRef>
                                                    <queryRef>/FalseSharing_big</queryRef>
                                                    <queryRef>/SplitStores_big</queryRef>
                                                    <queryRef>/Streaming_Stores_big</queryRef>
                                                    <derivedQuery id="DTLBStoreOverheadGroup">
                                                        <queryInherit>/DTLBStoreOverhead_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="DTLBStoreOverheadGroupExpanded">
                                                                <queryRef>/Store_STLB_Hit_big</queryRef>
                                                                <queryRef>/Store_STLB_Miss_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CoreBoundGroup">
                                <queryInherit>/CoreBound_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CoreBoundGroupExpanded">
                                        <queryRef>/DIVActive_big</queryRef>
                                        <derivedQuery id="PortUtilGroup">
                                            <queryInherit>/PortUtil_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="PortUtilGroupExpanded">
                                                    <derivedQuery id="Cycles0PortsUtilizedGroup">
                                                        <queryInherit>/Cycles0PortsUtilized_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Cycles0PortsUtilizedGroupExpanded">
                                                                <derivedQuery id="Serializing_OperationGroup">
                                                                    <queryInherit>/Serializing_Operation_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Serializing_OperationGroupExpanded">
                                                                            <queryRef>/Slow_Pause_big</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/Mixing_Vectors_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/Cycles1PortUtilized_big</queryRef>
                                                    <queryRef>/Cycles2PortsUtilized_big</queryRef>
                                                    <derivedQuery id="Cycles3mPortsUtilizedGroup">
                                                        <queryInherit>/Cycles3mPortsUtilized_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Cycles3mPortsUtilizedGroupExpanded">
                                                                <derivedQuery id="ALU_Op_UtilizationGroup">
                                                                    <queryInherit>/ALU_Op_Utilization_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="ALU_Op_UtilizationGroupExpanded">
                                                                            <queryRef>/Port0_big</queryRef>
                                                                            <queryRef>/Port1_big</queryRef>
                                                                            <queryRef>/Port5_big</queryRef>
                                                                            <queryRef>/Port6_big</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="Load_Op_UtilizationGroup">
                                                                    <queryInherit>/Load_Op_Utilization_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Load_Op_UtilizationGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="Store_Op_UtilizationGroup">
                                                                    <queryInherit>/Store_Op_Utilization_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Store_Op_UtilizationGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="Light_Operations_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") if query("/RetiredPipelineSlots_big") - query("/Heavy_Operations_big") > 0 else 0 ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Light_Operations_big") > 0.6 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_x87_big") + query("/FP_Scalar_big") + query("/FP_Vector_big") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Light_Operations_big") > 0.6 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="FP_x87_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") / query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_x87_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="FP_Scalar_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar_big") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Scalar_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="FP_Vector_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector_big") / query("/Retired_Slots_big") ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FP_Arith_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Light_Operations_big") > 0.6 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 1 - query("/FP_Arith_big") ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/OTHER_big") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Light_Operations_big") > 0.6 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="Heavy_Operations_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MicroSequencer_big") ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Heavy_Operations_big") > 0.1 ) ) && ( ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Retire_Fraction_big") * query("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MicroSequencer_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches_big") > 0.05) ) && ( ( query("/Heavy_Operations_big") > 0.1 ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Assists" id="Assists_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%AssistsDescriptionAll</description>
                    <helpKeyword>configs.assists_assistsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Avg_Assist_Cost_big") * query("/PMUEventCount/PMUEventType[ASSISTS.ANY]/PMUCoreType[Big Core]") / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Assists_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MicroSequencer_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches_big") > 0.05) && ( query("/Heavy_Operations_big") > 0.1 ) && ( ( query("/RetiredPipelineSlots_big") > 0.75 ) || ( queryOptional("/Heavy_Operations_big") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_big") * query("/PMUEventCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[Big Core]") / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ICACHE_16B.IFDATA_STALL]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ICacheMisses_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_16B.IFDATA_STALL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ICACHE_64B.IFTAG_STALL]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ITLBOverhead_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ICACHE_64B.IFTAG_STALL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") + query("/Unknown_Branches_big") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchResteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( (  ( query("/PMUSampleCount/PMUEventType[BACLEARS.ANY]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="Mispredicts_Resteers_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Mispredicts_ResteersDescriptionAll</description>
                    <helpKeyword>configs.mispredicts_resteers_mispredicts_resteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mispred_Clears_Fraction_big") * query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Mispredicts_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Mispredicts_Resteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/BranchMispredict_big") > 0.05) ) && ( ( ( query("/BranchResteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="Clears_Resteers_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Clears_ResteersDescriptionAll</description>
                    <helpKeyword>configs.clears_resteers_clears_resteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - query("/Mispred_Clears_Fraction_big") ) * query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Clears_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Clears_Resteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MachineClears_big") > 0.05) ) && ( ( ( query("/BranchResteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="Unknown_Branches_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BAClear_Cost_big") * query("/PMUEventCount/PMUEventType[BACLEARS.ANY]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Unknown_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Unknown_Branches_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchResteers_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[BACLEARS.ANY]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="DSBtoMITESwitchCost_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DSBtoMITESwitchCost_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="LCP_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ILD_STALL.LCP]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LCP_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ILD_STALL.LCP]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="MSSwitches_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MS_Switches_Cost_big") * query("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MSSwitches_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer_big") > 0.05) || ( queryOptional("/Serializing_Operation_big") > 0.1) ) && ( ( ( query("/FELatency_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FrontendBoundPipelineSlots_big") - query("/FELatency_big") if query("/FrontendBoundPipelineSlots_big") - query("/FELatency_big") > 0 else 0 ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidth_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( (  ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="FEBandwidthMITE_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.MITE_CYCLES_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[IDQ.MITE_CYCLES_OK]/PMUCoreType[Big Core]") ) / query("/CORE_CLKS_big") / 2 ) ]]></valueEval>
                    <issueText>%FEBandwidthMITEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthMITE_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FEBandwidth_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_CYCLES_OK]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="FEBandwidthDSB_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.DSB_CYCLES_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[IDQ.DSB_CYCLES_OK]/PMUCoreType[Big Core]") ) / query("/CORE_CLKS_big") / 2 ) ]]></valueEval>
                    <issueText>%FEBandwidthDSBIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthDSB_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FEBandwidth_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_OK]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthLSD" id="FEBandwidthLSD_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthLSDDescriptionAll</description>
                    <helpKeyword>configs.febandwidthlsd_febandwidthlsddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[LSD.CYCLES_ACTIVE]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[LSD.CYCLES_OK]/PMUCoreType[Big Core]") ) / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%FEBandwidthLSDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthLSD_big") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FEBandwidth_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[LSD.CYCLES_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.CYCLES_OK]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="DSB_Coverage_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") / query("/Fetched_Uops_big") ) ]]></valueEval>
                    <issueText>%DSB_CoverageIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DSB_Coverage_big") < 0.7 ) ) && ( ( ( query("/FEBandwidth_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.7 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Coverage" id="LSD_Coverage_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%LSD_CoverageDescriptionAll</description>
                    <helpKeyword>configs.lsd_coverage_lsd_coveragedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") / query("/Fetched_Uops_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 1 - ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") + query("/RetiredPipelineSlots_big") ) if 1 - ( query("/FrontendBoundPipelineSlots_big") + query("/BackendBound_big") + query("/RetiredPipelineSlots_big") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mispred_Clears_Fraction_big") * query("/CancelledPipelineSlots_big") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchMispredict_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Mispredicts_Resteers_big") > 0.05) ) && ( ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) ) ) || (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") if query("/CancelledPipelineSlots_big") - query("/BranchMispredict_big") > 0 else 0 ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MachineClears_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Clears_Resteers_big") > 0.05) ) && ( ( query("/CancelledPipelineSlots_big") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) ) ) || (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) ) if ( ( ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") + query("/Pipeline_Width_big") * query("/PMUEventCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") ) / query("/SLOTS_big") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound_big") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Memory_Bound_Fraction_big") * query("/BackendBound_big") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") ) / query("/DerivedClockticks_big") if ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") ) / query("/DerivedClockticks_big") > 0 else 0 ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") ) ) / query("/DerivedClockticks") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="DTLBOverhead_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_STLB_Hit_Cost_big") * query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") if query("/Mem_STLB_Hit_Cost_big") * query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") < ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") if query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") > 0 else 0 ) else ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") if query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") > 0 else 0 ) ) ]]></valueEval>
                    <issueText>%DTLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DTLBOverhead_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) > 0 ) ) else ( 0 ) ) ) ) ) else ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) > 0 ) ) else ( 0 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="Load_STLB_Hit_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DTLBOverhead_big") - query("/Load_STLB_Miss_big") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Load_STLB_Hit_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBOverhead_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) > 0 ) ) else ( 0 ) ) ) ) ) else ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) > 0 ) ) else ( 0 ) ) ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="Load_STLB_Miss_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Load_STLB_Miss_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBOverhead_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="LoadsBlockedbyStoreForwarding_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 13 * query("/PMUEventCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LoadsBlockedbyStoreForwarding_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="LockLatency_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LockLatencyDescriptionAll</description>
                    <helpKeyword>configs.locklatency_locklatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Lock_St_Fraction_big") * query("/ORO_Demand_RFO_C1_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%LockLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LockLatency_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/StoreLatency_big") > 0.1) ) && ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitLoads" id="SplitLoads_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SplitLoadsDescriptionAll</description>
                    <helpKeyword>configs.splitloads_splitloadsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Load_Miss_Real_Latency_big") * query("/PMUEventCount/PMUEventType[LD_BLOCKS.NO_SR]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%SplitLoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/SplitLoads_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]/PMUCoreType[Big Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) )  ) ) || ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.NO_SR]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%4KAliasing" id="4KAliasing_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%4KAliasingDescriptionAll</description>
                    <helpKeyword>configs.4kaliasing_4kaliasingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_BLOCKS_PARTIAL.ADDRESS_ALIAS]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%4KAliasingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/4KAliasing_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS_PARTIAL.ADDRESS_ALIAS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="FBFull_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FBFullDescriptionAll</description>
                    <helpKeyword>configs.fbfull_fbfulldescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.FB_FULL]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%FBFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FBFull_big") > 0.3 ) || ( queryOptional("/SQFull_big") > 0.3) || ( queryOptional("/MEMBandwidth_big") > 0.2) || ( queryOptional("/StoreLatency_big") > 0.1) ) && ( ( ( ( query("/L1Bound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) || ( queryOptional("/Cycles1PortUtilized_big") > 0.2) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/LOAD_L2_HIT_big") / ( query("/LOAD_L2_HIT_big") + query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.FB_FULL_PERIODS]/PMUCoreType[Big Core]") ) ) * query("/L2_Bound_Ratio_big") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL_PERIODS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L3_MISS]/PMUCoreType[Big Core]") ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L3_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="ContestedAccesses_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ContestedAccessesDescriptionAll</description>
                    <helpKeyword>configs.contestedaccesses_contestedaccessesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/Mem_XSNP_HitM_Cost_big") - query("/Mem_L2_Hit_Cost_big") ) * query("/LOAD_XSNP_HITM_big") + ( query("/Mem_XSNP_Hit_Cost_big") - query("/Mem_L2_Hit_Cost_big") ) * query("/LOAD_XSNP_MISS_big") ) * query("/FBHit_Factor_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%ContestedAccessesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ContestedAccesses_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DataSharing_big") > 0.05) || ( queryOptional("/RemoteCache_big") > 0.05) || ( queryOptional("/FalseSharing_big") > 0.05) ) && ( ( ( query("/L3Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="DataSharing_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DataSharingDescriptionAll</description>
                    <helpKeyword>configs.datasharing_datasharingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_XSNP_Hit_Cost_big") - query("/Mem_L2_Hit_Cost_big") ) * query("/LOAD_XSNP_HIT_big") * query("/FBHit_Factor_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%DataSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DataSharing_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/ContestedAccesses_big") > 0.05) || ( queryOptional("/RemoteCache_big") > 0.05) || ( queryOptional("/FalseSharing_big") > 0.05) ) && ( ( ( query("/L3Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="L3Latency_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3LatencyDescriptionAll</description>
                    <helpKeyword>configs.l3latency_l3latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_XSNP_None_Cost_big") - query("/Mem_L2_Hit_Cost_big") ) * query("/LOAD_L3_HIT_big") * query("/FBHit_Factor_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%L3LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Latency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MEMLatency_big") > 0.1) ) && ( ( ( query("/L3Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) || (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") >= 10 )  ) ) || (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="SQFull_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SQFullDescriptionAll</description>
                    <helpKeyword>configs.sqfull_sqfulldescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.L2_STALL]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%SQFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/SQFull_big") > 0.3 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull_big") > 0.3) || ( queryOptional("/MEMBandwidth_big") > 0.2) ) && ( ( ( query("/L3Bound_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.3 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_Bound_Ratio_big") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DRAMBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L3_MISS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL_PERIODS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="MEMBandwidth_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_BW_Cycles_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%MEMBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MEMBandwidth_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull_big") > 0.3) || ( queryOptional("/SQFull_big") > 0.3) ) && ( ( ( query("/DRAMBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="MEMLatency_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_Any_Cycles_big") / query("/DerivedClockticks_big") - query("/MEMBandwidth_big") ) ]]></valueEval>
                    <issueText>%MEMLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MEMLatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L3Latency_big") > 0.1) ) && ( ( ( query("/DRAMBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RemoteCache" id="RemoteCache">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="StoreLatency_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoreLatencyDescriptionAll</description>
                    <helpKeyword>configs.storelatency_storelatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Store_L2_Hit_Cycles_big") + ( 1 - query("/Mem_Lock_St_Fraction_big") ) * query("/ORO_Demand_RFO_C1_big") ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%StoreLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoreLatency_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/LockLatency_big") > 0.2) || ( queryOptional("/FBFull_big") > 0.3) ) && ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]/PMUCoreType[Big Core]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="FalseSharing_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FalseSharingDescriptionAll</description>
                    <helpKeyword>configs.falsesharing_falsesharingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_XSNP_HitM_Cost_big") * query("/PMUEventCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%FalseSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FalseSharing_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/ContestedAccesses_big") > 0.05) || ( queryOptional("/DataSharing_big") > 0.05) || ( queryOptional("/RemoteCache_big") > 0.05) ) && ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="SplitStores_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SplitStoresDescriptionAll</description>
                    <helpKeyword>configs.splitstores_splitstoresdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]/PMUCoreType[Big Core]") / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%SplitStoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/SplitStores_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Port4_big") > 0.6) ) && ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Streaming_Stores" id="Streaming_Stores_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Streaming_StoresDescriptionAll</description>
                    <helpKeyword>configs.streaming_stores_streaming_storesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 9 * query("/PMUEventCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Streaming_StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Streaming_Stores_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FBFull_big") > 0.3) ) && ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="DTLBStoreOverhead_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBStoreOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlbstoreoverhead_dtlbstoreoverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_STLB_Hit_Cost_big") * query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) / query("/CORE_CLKS_big") if ( query("/Mem_STLB_Hit_Cost_big") * query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) / query("/CORE_CLKS_big") < 1 else 1 ) ]]></valueEval>
                    <issueText>%DTLBStoreOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DTLBStoreOverhead_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/ClocktickSamples") >= 10 ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) ) / ( query("/ClocktickSamples") >= 10 ) ) < 1 ) ) else ( 1 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Hit" id="Store_STLB_Hit_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_hit_store_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DTLBStoreOverhead_big") - query("/Store_STLB_Miss_big") ) ]]></valueEval>
                    <issueText>%Store_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Store_STLB_Hit_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBStoreOverhead_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/ClocktickSamples") >= 10 ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) ) / ( query("/ClocktickSamples") >= 10 ) ) < 1 ) ) else ( 1 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Miss" id="Store_STLB_Miss_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_miss_store_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%Store_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Store_STLB_Miss_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DTLBStoreOverhead_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/StoresBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound_big">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_big") - query("/MemBound_big") if query("/BackendBound_big") - query("/MemBound_big") > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="DIVActive_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DIVActive_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="PortUtil_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Cycles_big") / query("/DerivedClockticks_big") if ( query("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") < ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") ) ) else query("/Few_Uops_Executed_Threshold_big") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles0PortsUtilized" id="Cycles0PortsUtilized_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles0PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles0portsutilized_cycles0portsutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Cycles0PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles0PortsUtilized_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Serializing_Operation_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches_big") > 0.05) ) && ( ( ( query("/Cycles0PortsUtilized_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Slow_Pause" id="Slow_Pause_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Slow_PauseDescriptionAll</description>
                    <helpKeyword>configs.slow_pause_slow_pausedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 140 * query("/PMUEventCount/PMUEventType[MISC_RETIRED.PAUSE_INST]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Slow_PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Slow_Pause_big") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches_big") > 0.05) && ( ( query("/Cycles0PortsUtilized_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[MISC_RETIRED.PAUSE_INST]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mixing_Vectors" id="Mixing_Vectors_big">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%Mixing_VectorsDescriptionAll</description>
                    <helpKeyword>configs.mixing_vectors_mixing_vectorsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_ISSUED.VECTOR_WIDTH_MISMATCH]/PMUCoreType[Big Core]") / query("/PMUEventCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <issueText>%Mixing_VectorsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Mixing_Vectors_big") > 0.05 ) ) && ( ( ( query("/Cycles0PortsUtilized_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.VECTOR_WIDTH_MISMATCH]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="Cycles1PortUtilized_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles1PortUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles1portutilized_cycles1portutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Cycles1PortUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles1PortUtilized_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/L1Bound_big") > 0.1) ) && ( ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="Cycles2PortsUtilized_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles2PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles2portsutilized_cycles2portsutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Cycles2PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles2PortsUtilized_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/Port0_big") > 0.6) || ( queryOptional("/Port1_big") > 0.6) || ( queryOptional("/Port5_big") > 0.6) || ( queryOptional("/Port6_big") > 0.6) ) && ( ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles3mPortsUtilized" id="Cycles3mPortsUtilized_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles3mPortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles3mportsutilized_cycles3mportsutilizeddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <issueText>%Cycles3mPortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.7 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ALU_Op_Utilization" id="ALU_Op_Utilization_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ALU_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.alu_op_utilization_alu_op_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_0]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_1]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_5]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_6]/PMUCoreType[Big Core]") ) / ( 4 * query("/CORE_CLKS_big") ) ) ]]></valueEval>
                    <issueText>%ALU_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ALU_Op_Utilization_big") > 0.6 ) ) && ( ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_5]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="Port0_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port0DescriptionAll</description>
                    <helpKeyword>configs.port0_port0descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_0]/PMUCoreType[Big Core]") / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port0_big") > 0.6 ) || ( queryOptional("/Cycles2PortsUtilized_big") > 0.2) || ( queryOptional("/Port1_big") > 0.6) || ( queryOptional("/Port5_big") > 0.6) || ( queryOptional("/Port6_big") > 0.6) ) && ( ( query("/ALU_Op_Utilization_big") > 0.6 ) && ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="Port1_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port1DescriptionAll</description>
                    <helpKeyword>configs.port1_port1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_1]/PMUCoreType[Big Core]") / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port1_big") > 0.6 ) || ( queryOptional("/Cycles2PortsUtilized_big") > 0.2) || ( queryOptional("/Port0_big") > 0.6) || ( queryOptional("/Port5_big") > 0.6) || ( queryOptional("/Port6_big") > 0.6) ) && ( ( query("/ALU_Op_Utilization_big") > 0.6 ) && ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port5" id="Port5_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port5DescriptionAll</description>
                    <helpKeyword>configs.port5_port5descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_5]/PMUCoreType[Big Core]") / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%Port5IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port5_big") > 0.6 ) || ( queryOptional("/Cycles2PortsUtilized_big") > 0.2) || ( queryOptional("/Port0_big") > 0.6) || ( queryOptional("/Port1_big") > 0.6) || ( queryOptional("/Port6_big") > 0.6) ) && ( ( query("/ALU_Op_Utilization_big") > 0.6 ) && ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_5]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="Port6_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port6DescriptionAll</description>
                    <helpKeyword>configs.port6_port6descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_6]/PMUCoreType[Big Core]") / query("/CORE_CLKS_big") ) ]]></valueEval>
                    <issueText>%Port6IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Port6_big") > 0.6 ) || ( queryOptional("/Cycles2PortsUtilized_big") > 0.2) || ( queryOptional("/Port0_big") > 0.6) || ( queryOptional("/Port1_big") > 0.6) || ( queryOptional("/Port5_big") > 0.6) ) && ( ( query("/ALU_Op_Utilization_big") > 0.6 ) && ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Op_Utilization" id="Load_Op_Utilization_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.load_op_utilization_load_op_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3]/PMUCoreType[Big Core]") / ( 2 * query("/CORE_CLKS_big") ) ) ]]></valueEval>
                    <issueText>%Load_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_Op_Utilization_big") > 0.6 ) ) && ( ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_Op_Utilization" id="Store_Op_Utilization_big">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.store_op_utilization_store_op_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_4_9]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]/PMUCoreType[Big Core]") ) / ( 4 * query("/CORE_CLKS_big") ) ) ]]></valueEval>
                    <issueText>%Store_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Store_Op_Utilization_big") > 0.6 ) ) && ( ( ( query("/Cycles3mPortsUtilized_big") > 0.7 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/PortUtil_big") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_big") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_big") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_4_9]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Port4" id="Port4">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS_big">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedIssueSlots_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="CORE_CLKS_big">
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.DISTRIBUTED]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.DISTRIBUTED]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Miss_Real_Latency" id="Load_Miss_Real_Latency_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Load_Miss_Real_LatencyDescriptionAll</description>
                    <helpKeyword>configs.load_miss_real_latency_load_miss_real_latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[L1D_PEND_MISS.PENDING]/PMUCoreType[Big Core]") / ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") + 1 ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]/PMUCoreType[Big Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Average_Frequency" id="Average_Frequency_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Average_FrequencyDescriptionAll</description>
                    <helpKeyword>configs.average_frequency_average_frequencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( (query("/AverageFrequency") / 1000000000.0) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Turbo_Utilization" id="Turbo_Utilization_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Turbo_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.turbo_utilization_turbo_utilizationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedClockticks_big") / query("/DerivedRefClockticks_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TimeTMA" id="TimeTMA_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%TimeTMADescriptionAll</description>
                    <helpKeyword>configs.timetma_timetmadescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInSeconds_big") ) ]]></valueEval>
                    <issueText>%TimeTMAIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/TimeTMA_big") < 1 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Backend_Bound_Cycles" id="Backend_Bound_Cycles_big">
                    <description>%Backend_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.backend_bound_cycles_backend_bound_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") + query("/Few_Uops_Executed_Threshold_big") + query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="Core_Bound_Cycles_big">
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") + query("/Few_Uops_Executed_Threshold_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInSeconds" id="DurationTimeInSeconds_big">
                    <description>%DurationTimeInSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinseconds_durationtimeinsecondsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInMilliSeconds_big") / 1000 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FBHit_Factor" id="FBHit_Factor_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%FBHit_FactorDescriptionAll</description>
                    <helpKeyword>configs.fbhit_factor_fbhit_factordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 1 + query("/FBHit_per_L1Miss_big") / 2 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FBHit_per_L1Miss" id="FBHit_per_L1Miss_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%FBHit_per_L1MissDescriptionAll</description>
                    <helpKeyword>configs.fbhit_per_l1miss_fbhit_per_l1missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") / query("/LOAD_L1_MISS_NET_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="Fetched_Uops_big">
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="Few_Uops_Executed_Threshold_big">
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") + query("/RetiredPipelineSlots_big") * query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="FP_Arith_Scalar_big">
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="FP_Arith_Vector_big">
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2_Bound_Ratio" id="L2_Bound_Ratio_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%L2_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.l2_bound_ratio_l2_bound_ratiodescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") - query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") ) / query("/DerivedClockticks_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L1_MISS_NET" id="LOAD_L1_MISS_NET_big">
                    <description>%LOAD_L1_MISS_NETDescriptionAll</description>
                    <helpKeyword>configs.load_l1_miss_net_load_l1_miss_netdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L2_HIT" id="LOAD_L2_HIT_big">
                    <description>%LOAD_L2_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l2_hit_load_l2_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") * ( 1 + query("/FBHit_per_L1Miss_big") ) + 1 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L3_HIT" id="LOAD_L3_HIT_big">
                    <description>%LOAD_L3_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l3_hit_load_l3_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") + 1 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") >= 10 )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HIT" id="LOAD_XSNP_HIT_big">
                    <description>%LOAD_XSNP_HITDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hit_load_xsnp_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HITM" id="LOAD_XSNP_HITM_big">
                    <description>%LOAD_XSNP_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hitm_load_xsnp_hitmdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_MISS" id="LOAD_XSNP_MISS_big">
                    <description>%LOAD_XSNP_MISSDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_miss_load_xsnp_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="MEM_Bound_Ratio_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L3_MISS]/PMUCoreType[Big Core]") / query("/DerivedClockticks_big") + query("/L2_Bound_Ratio_big") - query("/L2Bound_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L3_MISS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL_PERIODS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Store_Cost" id="Mem_L2_Store_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_L2_Store_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_store_cost_mem_l2_store_costdescriptionall</helpKeyword>
                    <valueEval>10</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Lock_St_Fraction" id="Mem_Lock_St_Fraction_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Lock_St_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_lock_st_fraction_mem_lock_st_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") / query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Bound_Fraction" id="Memory_Bound_Fraction_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Memory_Bound_FractionDescriptionAll</description>
                    <helpKeyword>configs.memory_bound_fraction_memory_bound_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") ) / query("/Backend_Bound_Cycles_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="Mispred_Clears_Fraction_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") / ( query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") + query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_Demand_RFO_C1" id="ORO_Demand_RFO_C1_big">
                    <description>%ORO_Demand_RFO_C1DescriptionAll</description>
                    <helpKeyword>configs.oro_demand_rfo_c1_oro_demand_rfo_c1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks_big") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ? query("/DerivedClockticks_big") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="ORO_DRD_Any_Cycles_big">
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks_big") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ? query("/DerivedClockticks_big") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="ORO_DRD_BW_Cycles_big">
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks_big") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ? query("/DerivedClockticks_big") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>5</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="Retire_Fraction_big">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots_big") / query("/PMUEventCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="Retired_Slots_big">
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_L2_Hit_Cycles" id="Store_L2_Hit_Cycles_big">
                    <description>%Store_L2_Hit_CyclesDescriptionAll</description>
                    <helpKeyword>configs.store_l2_hit_cycles_store_l2_hit_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[L2_RQSTS.RFO_HIT]/PMUCoreType[Big Core]") * query("/Mem_L2_Store_Cost_big") * ( 1 - query("/Mem_Lock_St_Fraction_big") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]/PMUCoreType[Big Core]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_STLB_Hit_Cost" id="Mem_STLB_Hit_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_STLB_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_stlb_hit_cost_mem_stlb_hit_costdescriptionall</helpKeyword>
                    <valueEval>7</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_HitM_Cost" id="Mem_XSNP_HitM_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_XSNP_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hitm_cost_mem_xsnp_hitm_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 32.5 * query("/Average_Frequency_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_Hit_Cost" id="Mem_XSNP_Hit_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_XSNP_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hit_cost_mem_xsnp_hit_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 27 * query("/Average_Frequency_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_None_Cost" id="Mem_XSNP_None_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_XSNP_None_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_none_cost_mem_xsnp_none_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 12.5 * query("/Average_Frequency_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Hit_Cost" id="Mem_L2_Hit_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_L2_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_hit_cost_mem_l2_hit_costdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 3.5 * query("/Average_Frequency_big") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BAClear_Cost" id="BAClear_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%BAClear_CostDescriptionAll</description>
                    <helpKeyword>configs.baclear_cost_baclear_costdescriptionall</helpKeyword>
                    <valueEval>10</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MS_Switches_Cost" id="MS_Switches_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%MS_Switches_CostDescriptionAll</description>
                    <helpKeyword>configs.ms_switches_cost_ms_switches_costdescriptionall</helpKeyword>
                    <valueEval>3</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Avg_Assist_Cost" id="Avg_Assist_Cost_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Avg_Assist_CostDescriptionAll</description>
                    <helpKeyword>configs.avg_assist_cost_avg_assist_costdescriptionall</helpKeyword>
                    <valueEval>100 * query("/Pipeline_Width_big")</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%OneBillion" id="OneBillion_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%OneBillionDescriptionAll</description>
                    <helpKeyword>configs.onebillion_onebilliondescriptionall</helpKeyword>
                    <valueEval>1000000000</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInMilliSeconds" id="DurationTimeInMilliSeconds_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%DurationTimeInMilliSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinmilliseconds_durationtimeinmillisecondsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( (query("/GlobalElapsedTimeQueryAll") * 1000) ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%TSC" id="TSC_big">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%TSCDescriptionAll</description>
                    <helpKeyword>configs.tsc_tscdescriptionall</helpKeyword>
                    <valueEval>$referenceFrequency</valueEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown_big" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorLight_OperationsGroup">
                                            <queryInherit>/locatorLight_Operations_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorLight_OperationsGroupExpanded">
                                                    <derivedQuery id="locatorFP_ArithGroup">
                                                        <queryInherit>/locatorFP_Arith_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorFP_ArithGroupExpanded">
                                                                <queryRef>/locatorFP_x87_big</queryRef>
                                                                <queryRef>/locatorFP_Scalar_big</queryRef>
                                                                <queryRef>/locatorFP_Vector_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorOTHER_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorHeavy_OperationsGroup">
                                            <queryInherit>/locatorHeavy_Operations_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorHeavy_OperationsGroupExpanded">
                                                    <derivedQuery id="locatorMicroSequencerGroup">
                                                        <queryInherit>/locatorMicroSequencer_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMicroSequencerGroupExpanded">
                                                                <queryRef>/locatorAssists_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses_big</queryRef>
                                                    <queryRef>/locatorITLBOverhead_big</queryRef>
                                                    <derivedQuery id="locatorBranchResteersGroup">
                                                        <queryInherit>/locatorBranchResteers_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorBranchResteersGroupExpanded">
                                                                <queryRef>/locatorMispredicts_Resteers_big</queryRef>
                                                                <queryRef>/locatorClears_Resteers_big</queryRef>
                                                                <queryRef>/locatorUnknown_Branches_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorDSBtoMITESwitchCost_big</queryRef>
                                                    <queryRef>/locatorLCP_big</queryRef>
                                                    <queryRef>/locatorMSSwitches_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthMITE_big</queryRef>
                                                    <queryRef>/locatorFEBandwidthDSB_big</queryRef>
                                                    <queryRef>/locatorFEBandwidthLSD_big</queryRef>
                                                    <queryRef>/locatorDSB_Coverage_big</queryRef>
                                                    <queryRef>/locatorLSD_Coverage_big</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <queryRef>/locatorBranchMispredict_big</queryRef>
                                        <queryRef>/locatorMachineClears_big</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound_big</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <derivedQuery id="locatorL1BoundGroup">
                                                        <queryInherit>/locatorL1Bound_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL1BoundGroupExpanded">
                                                                <derivedQuery id="locatorDTLBOverheadGroup">
                                                                    <queryInherit>/locatorDTLBOverhead_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorDTLBOverheadGroupExpanded">
                                                                            <queryRef>/locatorLoad_STLB_Hit_big</queryRef>
                                                                            <queryRef>/locatorLoad_STLB_Miss_big</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorLoadsBlockedbyStoreForwarding_big</queryRef>
                                                                <queryRef>/locatorLockLatency_big</queryRef>
                                                                <queryRef>/locatorSplitLoads_big</queryRef>
                                                                <queryRef>/locator4KAliasing_big</queryRef>
                                                                <queryRef>/locatorFBFull_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL2Bound_big</queryRef>
                                                    <derivedQuery id="locatorL3BoundGroup">
                                                        <queryInherit>/locatorL3Bound_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL3BoundGroupExpanded">
                                                                <queryRef>/locatorContestedAccesses_big</queryRef>
                                                                <queryRef>/locatorDataSharing_big</queryRef>
                                                                <queryRef>/locatorL3Latency_big</queryRef>
                                                                <queryRef>/locatorSQFull_big</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorDRAMBoundGroup">
                                                        <queryInherit>/locatorDRAMBound_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorDRAMBoundGroupExpanded">
                                                                <queryRef>/locatorMEMBandwidth_big</queryRef>
                                                                <derivedQuery id="locatorMEMLatencyGroup">
                                                                    <queryInherit>/locatorMEMLatency_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorMEMLatencyGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorStoresBoundGroup">
                                                        <queryInherit>/locatorStoresBound_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorStoresBoundGroupExpanded">
                                                                <queryRef>/locatorStoreLatency_big</queryRef>
                                                                <queryRef>/locatorFalseSharing_big</queryRef>
                                                                <queryRef>/locatorSplitStores_big</queryRef>
                                                                <queryRef>/locatorStreaming_Stores_big</queryRef>
                                                                <derivedQuery id="locatorDTLBStoreOverheadGroup">
                                                                    <queryInherit>/locatorDTLBStoreOverhead_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorDTLBStoreOverheadGroupExpanded">
                                                                            <queryRef>/locatorStore_STLB_Hit_big</queryRef>
                                                                            <queryRef>/locatorStore_STLB_Miss_big</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>/locatorCoreBound_big</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <queryRef>/locatorDIVActive_big</queryRef>
                                                    <derivedQuery id="locatorPortUtilGroup">
                                                        <queryInherit>/locatorPortUtil_big</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorPortUtilGroupExpanded">
                                                                <derivedQuery id="locatorCycles0PortsUtilizedGroup">
                                                                    <queryInherit>/locatorCycles0PortsUtilized_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorCycles0PortsUtilizedGroupExpanded">
                                                                            <derivedQuery id="locatorSerializing_OperationGroup">
                                                                                <queryInherit>/locatorSerializing_Operation_big</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorSerializing_OperationGroupExpanded">
                                                                                        <queryRef>/locatorSlow_Pause_big</queryRef>
                                                                                    </vectorQuery>
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <queryRef>/locatorMixing_Vectors_big</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorCycles1PortUtilized_big</queryRef>
                                                                <queryRef>/locatorCycles2PortsUtilized_big</queryRef>
                                                                <derivedQuery id="locatorCycles3mPortsUtilizedGroup">
                                                                    <queryInherit>/locatorCycles3mPortsUtilized_big</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorCycles3mPortsUtilizedGroupExpanded">
                                                                            <derivedQuery id="locatorALU_Op_UtilizationGroup">
                                                                                <queryInherit>/locatorALU_Op_Utilization_big</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorALU_Op_UtilizationGroupExpanded">
                                                                                        <queryRef>/locatorPort0_big</queryRef>
                                                                                        <queryRef>/locatorPort1_big</queryRef>
                                                                                        <queryRef>/locatorPort5_big</queryRef>
                                                                                        <queryRef>/locatorPort6_big</queryRef>
                                                                                    </vectorQuery>
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="locatorLoad_Op_UtilizationGroup">
                                                                                <queryInherit>/locatorLoad_Op_Utilization_big</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorLoad_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="locatorStore_Op_UtilizationGroup">
                                                                                <queryInherit>/locatorStore_Op_Utilization_big</queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorStore_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true)) * queryAll("/RetiredPipelineSlots_big", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") > 0.75 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="locatorLight_Operations_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[Big Core]", true)) * queryAll("/Light_Operations_big", true) ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLight_Operations") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="locatorFP_x87_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_x87_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true) ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_x87") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="locatorFP_Scalar_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Scalar_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true) ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Scalar") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="locatorFP_Vector_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true) ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.X87]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/OTHER_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true) ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOTHER") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="locatorHeavy_Operations_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Heavy_Operations_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorHeavy_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]", true)) * queryAll("/MicroSequencer_big", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Assists" id="locatorAssists_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%AssistsDescriptionAll</description>
                    <helpKeyword>configs.assists_assistsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ASSISTS.ANY]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ASSISTS.ANY]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[ASSISTS.ANY]/PMUCoreType[Big Core]", true)) * queryAll("/Assists_big", true) ) ]]></valueEval>
                    <issueText>%AssistsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorAssists") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_4]/PMUCoreType[Big Core]", true)) * queryAll("/FrontendBoundPipelineSlots_big", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_16]/PMUCoreType[Big Core]", true)) * queryAll("/FELatency_big", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.L2_MISS]/PMUCoreType[Big Core]", true)) * queryAll("/ICacheMisses_big", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.STLB_MISS]/PMUCoreType[Big Core]", true)) * queryAll("/ITLBOverhead_big", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]", true)) * queryAll("/BranchResteers_big", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="locatorMispredicts_Resteers_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mispredicts_ResteersDescriptionAll</description>
                    <helpKeyword>configs.mispredicts_resteers_mispredicts_resteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]", true)) * queryAll("/Mispredicts_Resteers_big", true) ) ]]></valueEval>
                    <issueText>%Mispredicts_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMispredicts_Resteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="locatorClears_Resteers_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Clears_ResteersDescriptionAll</description>
                    <helpKeyword>configs.clears_resteers_clears_resteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[INT_MISC.CLEAR_RESTEER_CYCLES]/PMUCoreType[Big Core]", true)) * queryAll("/Clears_Resteers_big", true) ) ]]></valueEval>
                    <issueText>%Clears_ResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorClears_Resteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="locatorUnknown_Branches_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[BACLEARS.ANY]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[BACLEARS.ANY]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[BACLEARS.ANY]/PMUCoreType[Big Core]", true)) * queryAll("/Unknown_Branches_big", true) ) ]]></valueEval>
                    <issueText>%Unknown_BranchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorUnknown_Branches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="locatorDSBtoMITESwitchCost_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[Big Core]", true)) * queryAll("/DSBtoMITESwitchCost_big", true) ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSBtoMITESwitchCost") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="locatorLCP_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ILD_STALL.LCP]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LCP_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLCP") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="locatorMSSwitches_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]/PMUCoreType[Big Core]", true)) * queryAll("/MSSwitches_big", true) ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMSSwitches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.LATENCY_GE_2_BUBBLES_GE_1]/PMUCoreType[Big Core]", true)) * queryAll("/FEBandwidth_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="locatorFEBandwidthMITE_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[FRONTEND_RETIRED.DSB_MISS]/PMUCoreType[Big Core]", true)) * queryAll("/FEBandwidthMITE_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthMITEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthMITE") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="locatorFEBandwidthDSB_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_CYCLES_OK]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDSB_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDSBIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDSB") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthLSD" id="locatorFEBandwidthLSD_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthLSDDescriptionAll</description>
                    <helpKeyword>configs.febandwidthlsd_febandwidthlsddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[LSD.CYCLES_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.CYCLES_OK]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthLSD_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthLSDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthLSD") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="locatorDSB_Coverage_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]", true)) * queryAll("/DSB_Coverage_big", true) ) ]]></valueEval>
                    <issueText>%DSB_CoverageIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSB_Coverage") < 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Coverage" id="locatorLSD_Coverage_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LSD_CoverageDescriptionAll</description>
                    <helpKeyword>configs.lsd_coverage_lsd_coveragedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]", true)) * queryAll("/LSD_Coverage_big", true) ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[INT_MISC.UOP_DROPPING]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( 1 - ( ( query("/FrontendBoundPipelineSlots") + query("/BackendBound") ) + query("/RetiredPipelineSlots") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.BR_MISPREDICT_SLOTS]/PMUCoreType[Big Core]", true)) * queryAll("/BranchMispredict_big", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]", true)) * queryAll("/MachineClears_big", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]", true)) * queryAll("/BackendBound_big", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]", true)) * queryAll("/MemBound_big", true) ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L1_HIT]/PMUCoreType[Big Core]", true)) * queryAll("/L1Bound_big", true) ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="locatorDTLBOverhead_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_LOADS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_LOADS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_LOADS]/PMUCoreType[Big Core]", true)) * queryAll("/DTLBOverhead_big", true) ) ]]></valueEval>
                    <issueText>%DTLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDTLBOverhead") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="locatorLoad_STLB_Hit_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]/PMUCoreType[Big Core]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) > 0 ) ) else ( 0 ) ) ) ) ) else ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_MEM_ANY]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_L1D_MISS]/PMUCoreType[Big Core]") ) ) > 0 ) ) else ( 0 ) ) ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Load_STLB_Hit_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Hit") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="locatorLoad_STLB_Miss_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Load_STLB_Miss_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Miss") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="locatorLoadsBlockedbyStoreForwarding_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS.STORE_FORWARD]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LoadsBlockedbyStoreForwarding_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoadsBlockedbyStoreForwarding") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="locatorLockLatency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LockLatencyDescriptionAll</description>
                    <helpKeyword>configs.locklatency_locklatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]", true)) * queryAll("/LockLatency_big", true) ) ]]></valueEval>
                    <issueText>%LockLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLockLatency") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitLoads" id="locatorSplitLoads_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SplitLoadsDescriptionAll</description>
                    <helpKeyword>configs.splitloads_splitloadsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_LOADS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_LOADS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_LOADS]/PMUCoreType[Big Core]", true)) * queryAll("/SplitLoads_big", true) ) ]]></valueEval>
                    <issueText>%SplitLoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSplitLoads") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%4KAliasing" id="locator4KAliasing_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%4KAliasingDescriptionAll</description>
                    <helpKeyword>configs.4kaliasing_4kaliasingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_BLOCKS_PARTIAL.ADDRESS_ALIAS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/4KAliasing_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%4KAliasingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locator4KAliasing") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="locatorFBFull_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FBFullDescriptionAll</description>
                    <helpKeyword>configs.fbfull_fbfulldescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FBFull_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%FBFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFBFull") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]", true)) * queryAll("/L2Bound_big", true) ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]", true)) * queryAll("/L3Bound_big", true) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="locatorContestedAccesses_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ContestedAccessesDescriptionAll</description>
                    <helpKeyword>configs.contestedaccesses_contestedaccessesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]", true)) * queryAll("/ContestedAccesses_big", true) ) ]]></valueEval>
                    <issueText>%ContestedAccessesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorContestedAccesses") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="locatorDataSharing_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DataSharingDescriptionAll</description>
                    <helpKeyword>configs.datasharing_datasharingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]", true)) * queryAll("/DataSharing_big", true) ) ]]></valueEval>
                    <issueText>%DataSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDataSharing") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="locatorL3Latency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3LatencyDescriptionAll</description>
                    <helpKeyword>configs.l3latency_l3latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]", true)) * queryAll("/L3Latency_big", true) ) ]]></valueEval>
                    <issueText>%L3LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Latency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="locatorSQFull_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SQFullDescriptionAll</description>
                    <helpKeyword>configs.sqfull_sqfulldescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.L2_STALL]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/SQFull_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%SQFullIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSQFull") > 0.3 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_MISS]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_MISS]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_RETIRED.L3_MISS]/PMUCoreType[Big Core]", true)) * queryAll("/DRAMBound_big", true) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="locatorMEMBandwidth_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MEMBandwidth_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%MEMBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMEMBandwidth") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="locatorMEMLatency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MEMLatency_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%MEMLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMEMLatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]", true)) * queryAll("/StoresBound_big", true) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="locatorStoreLatency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoreLatencyDescriptionAll</description>
                    <helpKeyword>configs.storelatency_storelatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]/PMUCoreType[Big Core]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/StoreLatency_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%StoreLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoreLatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="locatorFalseSharing_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FalseSharingDescriptionAll</description>
                    <helpKeyword>configs.falsesharing_falsesharingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) || ( query("/PMUSampleCount/PMUEventType[OCR.DEMAND_RFO.L3_HIT.SNOOP_HITM]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FalseSharing_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%FalseSharingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFalseSharing") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="locatorSplitStores_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SplitStoresDescriptionAll</description>
                    <helpKeyword>configs.splitstores_splitstoresdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.SPLIT_STORES]/PMUCoreType[Big Core]", true)) * queryAll("/SplitStores_big", true) ) ]]></valueEval>
                    <issueText>%SplitStoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSplitStores") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Streaming_Stores" id="locatorStreaming_Stores_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Streaming_StoresDescriptionAll</description>
                    <helpKeyword>configs.streaming_stores_streaming_storesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[OCR.STREAMING_WR.ANY_RESPONSE]/PMUCoreType[Big Core]", true)) * queryAll("/Streaming_Stores_big", true) ) ]]></valueEval>
                    <issueText>%Streaming_StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStreaming_Stores") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="locatorDTLBStoreOverhead_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBStoreOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlbstoreoverhead_dtlbstoreoverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_STORES]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_STORES]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MEM_INST_RETIRED.STLB_MISS_STORES]/PMUCoreType[Big Core]", true)) * queryAll("/DTLBStoreOverhead_big", true) ) ]]></valueEval>
                    <issueText>%DTLBStoreOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDTLBStoreOverhead") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Hit" id="locatorStore_STLB_Hit_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_hit_store_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/ClocktickSamples") >= 10 ) ) if ( ( ( ( ( 111 * ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.STLB_HIT]/PMUCoreType[Big Core]") ) ) + ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") ) ) / ( query("/ClocktickSamples") >= 10 ) ) < 1 ) ) else ( 1 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Store_STLB_Hit_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%Store_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStore_STLB_Hit") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Miss" id="locatorStore_STLB_Miss_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_miss_store_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DTLB_STORE_MISSES.WALK_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Store_STLB_Miss_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%Store_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStore_STLB_Miss") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.BACKEND_BOUND_SLOTS]/PMUCoreType[Big Core]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES:cmask=1:e=yes]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/BackendBound") - query("/MemBound") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CoreBound_big") * query("/SLOTS_big")) / queryAll("/SLOTS_big", true) ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="locatorDIVActive_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]", true)) * queryAll("/DIVActive_big", true) ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDIVActive") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="locatorPortUtil_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) if ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.DIVIDER_ACTIVE]/PMUCoreType[Big Core]") ) < ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") ) - ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") ) ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PortUtil_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPortUtil") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles0PortsUtilized" id="locatorCycles0PortsUtilized_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles0PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles0portsutilized_cycles0portsutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Cycles0PortsUtilized_big") * query("/DerivedClockticks_big")) / queryAll("/DerivedClockticks_big", true) ) ]]></valueEval>
                    <issueText>%Cycles0PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles0PortsUtilized") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SCOREBOARD]/PMUCoreType[Big Core]", true)) * queryAll("/Serializing_Operation_big", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Slow_Pause" id="locatorSlow_Pause_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Slow_PauseDescriptionAll</description>
                    <helpKeyword>configs.slow_pause_slow_pausedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MISC_RETIRED.PAUSE_INST]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MISC_RETIRED.PAUSE_INST]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[MISC_RETIRED.PAUSE_INST]/PMUCoreType[Big Core]", true)) * queryAll("/Slow_Pause_big", true) ) ]]></valueEval>
                    <issueText>%Slow_PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSlow_Pause") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mixing_Vectors" id="locatorMixing_Vectors_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mixing_VectorsDescriptionAll</description>
                    <helpKeyword>configs.mixing_vectors_mixing_vectorsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.VECTOR_WIDTH_MISMATCH]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Mixing_Vectors_big") * query("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]", true) ) ]]></valueEval>
                    <issueText>%Mixing_VectorsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMixing_Vectors") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="locatorCycles1PortUtilized_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles1PortUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles1portutilized_cycles1portutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]", true)) * queryAll("/Cycles1PortUtilized_big", true) ) ]]></valueEval>
                    <issueText>%Cycles1PortUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles1PortUtilized") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="locatorCycles2PortsUtilized_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles2PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles2portsutilized_cycles2portsutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]", true)) * queryAll("/Cycles2PortsUtilized_big", true) ) ]]></valueEval>
                    <issueText>%Cycles2PortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles2PortsUtilized") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles3mPortsUtilized" id="locatorCycles3mPortsUtilized_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles3mPortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles3mportsutilized_cycles3mportsutilizeddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[UOPS_EXECUTED.CYCLES_GE_3]/PMUCoreType[Big Core]", true)) * queryAll("/Cycles3mPortsUtilized_big", true) ) ]]></valueEval>
                    <issueText>%Cycles3mPortsUtilizedIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCycles3mPortsUtilized") > 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ALU_Op_Utilization" id="locatorALU_Op_Utilization_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ALU_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.alu_op_utilization_alu_op_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_5]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ALU_Op_Utilization_big") * query("/CORE_CLKS_big")) / queryAll("/CORE_CLKS_big", true) ) ]]></valueEval>
                    <issueText>%ALU_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorALU_Op_Utilization") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="locatorPort0_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port0DescriptionAll</description>
                    <helpKeyword>configs.port0_port0descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_0]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port0_big") * query("/CORE_CLKS_big")) / queryAll("/CORE_CLKS_big", true) ) ]]></valueEval>
                    <issueText>%Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort0") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="locatorPort1_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port1DescriptionAll</description>
                    <helpKeyword>configs.port1_port1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_1]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port1_big") * query("/CORE_CLKS_big")) / queryAll("/CORE_CLKS_big", true) ) ]]></valueEval>
                    <issueText>%Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort1") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port5" id="locatorPort5_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port5DescriptionAll</description>
                    <helpKeyword>configs.port5_port5descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_5]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port5_big") * query("/CORE_CLKS_big")) / queryAll("/CORE_CLKS_big", true) ) ]]></valueEval>
                    <issueText>%Port5IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort5") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="locatorPort6_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port6DescriptionAll</description>
                    <helpKeyword>configs.port6_port6descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_6]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Port6_big") * query("/CORE_CLKS_big")) / queryAll("/CORE_CLKS_big", true) ) ]]></valueEval>
                    <issueText>%Port6IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPort6") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Op_Utilization" id="locatorLoad_Op_Utilization_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.load_op_utilization_load_op_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_2_3]/PMUCoreType[Big Core]", true)) * queryAll("/Load_Op_Utilization_big", true) ) ]]></valueEval>
                    <issueText>%Load_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_Op_Utilization") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_Op_Utilization" id="locatorStore_Op_Utilization_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.store_op_utilization_store_op_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]/PMUCoreType[Big Core]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]/PMUCoreType[Big Core]") / queryAll("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.PORT_7_8]/PMUCoreType[Big Core]", true)) * queryAll("/Store_Op_Utilization_big", true) ) ]]></valueEval>
                    <issueText>%Store_Op_UtilizationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStore_Op_Utilization") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SLOTS_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="locatorCORE_CLKS_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.DISTRIBUTED]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/CORE_CLKS_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_Miss_Real_Latency" id="locatorLoad_Miss_Real_Latency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_Miss_Real_LatencyDescriptionAll</description>
                    <helpKeyword>configs.load_miss_real_latency_load_miss_real_latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.PENDING]/PMUCoreType[Big Core]") >= 10 ) && ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_Miss_Real_Latency_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Average_Frequency" id="locatorAverage_Frequency_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Average_FrequencyDescriptionAll</description>
                    <helpKeyword>configs.average_frequency_average_frequencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Average_Frequency_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Turbo_Utilization" id="locatorTurbo_Utilization_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Turbo_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.turbo_utilization_turbo_utilizationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Turbo_Utilization_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%TimeTMA" id="locatorTimeTMA_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%TimeTMADescriptionAll</description>
                    <helpKeyword>configs.timetma_timetmadescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/TimeTMA_big") ) ]]></valueEval>
                    <issueText>%TimeTMAIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorTimeTMA") < 1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Backend_Bound_Cycles" id="locatorBackend_Bound_Cycles_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Backend_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.backend_bound_cycles_backend_bound_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Backend_Bound_Cycles_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="locatorCore_Bound_Cycles_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Cycles_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInSeconds" id="locatorDurationTimeInSeconds_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DurationTimeInSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinseconds_durationtimeinsecondsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInSeconds_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FBHit_Factor" id="locatorFBHit_Factor_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FBHit_FactorDescriptionAll</description>
                    <helpKeyword>configs.fbhit_factor_fbhit_factordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FBHit_Factor_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FBHit_per_L1Miss" id="locatorFBHit_per_L1Miss_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FBHit_per_L1MissDescriptionAll</description>
                    <helpKeyword>configs.fbhit_per_l1miss_fbhit_per_l1missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FBHit_per_L1Miss_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="locatorFetched_Uops_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Fetched_Uops_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="locatorFew_Uops_Executed_Threshold_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Few_Uops_Executed_Threshold_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="locatorFP_Arith_Scalar_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_SINGLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.SCALAR_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="locatorFP_Arith_Vector_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE]/PMUCoreType[Big Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2_Bound_Ratio" id="locatorL2_Bound_Ratio_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.l2_bound_ratio_l2_bound_ratiodescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2_Bound_Ratio_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L1_MISS_NET" id="locatorLOAD_L1_MISS_NET_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_L1_MISS_NETDescriptionAll</description>
                    <helpKeyword>configs.load_l1_miss_net_load_l1_miss_netdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LOAD_L1_MISS_NET_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L2_HIT" id="locatorLOAD_L2_HIT_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_L2_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l2_hit_load_l2_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LOAD_L2_HIT_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L3_HIT" id="locatorLOAD_L3_HIT_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_L3_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l3_hit_load_l3_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L3_HIT]/PMUCoreType[Big Core]") >= 10 )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LOAD_L3_HIT_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HIT" id="locatorLOAD_XSNP_HIT_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_XSNP_HITDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hit_load_xsnp_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HIT]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LOAD_XSNP_HIT_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HITM" id="locatorLOAD_XSNP_HITM_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_XSNP_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hitm_load_xsnp_hitmdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_HITM]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LOAD_XSNP_HITM_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_MISS" id="locatorLOAD_XSNP_MISS_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_XSNP_MISSDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_miss_load_xsnp_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_L3_HIT_RETIRED.XSNP_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LOAD_XSNP_MISS_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="locatorMEM_Bound_Ratio_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L3_MISS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L2_HIT]/PMUCoreType[Big Core]") >= 10 ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.FB_HIT]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_RETIRED.L1_MISS]/PMUCoreType[Big Core]") >= 10 ) ) ) )  ) || ( query("/PMUSampleCount/PMUEventType[L1D_PEND_MISS.FB_FULL_PERIODS]/PMUCoreType[Big Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_MISS]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_MISS]/PMUCoreType[Big Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_Bound_Ratio_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Lock_St_Fraction" id="locatorMem_Lock_St_Fraction_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Lock_St_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_lock_st_fraction_mem_lock_st_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Lock_St_Fraction_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Bound_Fraction" id="locatorMemory_Bound_Fraction_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_Bound_FractionDescriptionAll</description>
                    <helpKeyword>configs.memory_bound_fraction_memory_bound_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_MEM_ANY]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_TOTAL]/PMUCoreType[Big Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.1_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.2_PORTS_UTIL]/PMUCoreType[Big Core]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[EXE_ACTIVITY.BOUND_ON_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Memory_Bound_Fraction_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="locatorMispred_Clears_Fraction_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]/PMUCoreType[Big Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mispred_Clears_Fraction_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_Demand_RFO_C1" id="locatorORO_Demand_RFO_C1_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_Demand_RFO_C1DescriptionAll</description>
                    <helpKeyword>configs.oro_demand_rfo_c1_oro_demand_rfo_c1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DEMAND_RFO]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_Demand_RFO_C1_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="locatorORO_DRD_Any_Cycles_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_Any_Cycles_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="locatorORO_DRD_BW_Cycles_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=4]/PMUCoreType[Big Core]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_BW_Cycles_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="locatorRetire_Fraction_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]/PMUCoreType[Big Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Retire_Fraction_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="locatorRetired_Slots_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.SLOTS]/PMUCoreType[Big Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Store_L2_Hit_Cycles" id="locatorStore_L2_Hit_Cycles_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_L2_Hit_CyclesDescriptionAll</description>
                    <helpKeyword>configs.store_l2_hit_cycles_store_l2_hit_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[L2_RQSTS.RFO_HIT]/PMUCoreType[Big Core]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.LOCK_LOADS]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_INST_RETIRED.ALL_STORES]/PMUCoreType[Big Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Store_L2_Hit_Cycles_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_HitM_Cost" id="locatorMem_XSNP_HitM_Cost_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_XSNP_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hitm_cost_mem_xsnp_hitm_costdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_XSNP_HitM_Cost_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_Hit_Cost" id="locatorMem_XSNP_Hit_Cost_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_XSNP_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hit_cost_mem_xsnp_hit_costdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_XSNP_Hit_Cost_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_None_Cost" id="locatorMem_XSNP_None_Cost_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_XSNP_None_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_none_cost_mem_xsnp_none_costdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_XSNP_None_Cost_big") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Hit_Cost" id="locatorMem_L2_Hit_Cost_big">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_L2_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_hit_cost_mem_l2_hit_costdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[Big Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_TSC]/PMUCoreType[Big Core]") >= 10 ) )  )  )  ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_L2_Hit_Cost_big") ) ]]></valueEval>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
