#===============================================================================
# Copyright 2019 Intel Corporation
#
#
# Licensed under the Apache License, Version 2.0 (the 'License');
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# 
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an 'AS IS' BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions
# and limitations under the License.
#
#===============================================================================

#
# Intel® Integrated Performance Primitives (Intel® IPP) library detection routine
# (version compatibility rules).
#

include_guard()

include("${CMAKE_CURRENT_LIST_DIR}/IPPUtils.cmake")

set(PACKAGE_VERSION ${IPP_INTERFACE_VERSION})

set(PACKAGE_VERSION_EXACT False)
set(PACKAGE_VERSION_COMPATIBLE False)

if (PACKAGE_FIND_VERSION VERSION_EQUAL PACKAGE_VERSION)
    set(PACKAGE_VERSION_EXACT True)
    set(PACKAGE_VERSION_COMPATIBLE True)
endif ()

if (PACKAGE_FIND_VERSION_MAJOR EQUAL ${IPP_INTERFACE_VERSION_MAJOR}
    AND PACKAGE_FIND_VERSION VERSION_LESS PACKAGE_VERSION)
    set(PACKAGE_VERSION_COMPATIBLE True)
endif ()
