module acl_timer #
(
    parameter WIDTH = 64,
    parameter USE_2XCLK = 0,
    parameter S_WIDTH_A = 2
)
(
    input clk,
    input clk2x,
    input resetn,

    // Agent port
    input [S_WIDTH_A-1:0] agent_address,  // Word address
    input [WIDTH-1:0] agent_writedata,
    input agent_read,
    input agent_write,
    input [WIDTH/8-1:0] agent_byteenable,
    output agent_waitrequest,
    output [WIDTH-1:0] agent_readdata,
    output agent_readdatavalid
);

reg [WIDTH-1:0] counter;
reg [WIDTH-1:0] counter2x;

reg clock_sel;

always@(posedge clk or negedge resetn)
  if (!resetn)
    clock_sel <= 1'b0;
  else if (agent_write)
    if (|agent_writedata)
      clock_sel <= 1'b1;
    else
      clock_sel <= 1'b0;

always@(posedge clk or negedge resetn)
  if (!resetn)
    counter <= {WIDTH{1'b0}};
  else if (agent_write)
    counter <= {WIDTH{1'b0}};
  else
    counter <= counter + 2'b01;

always@(posedge clk2x or negedge resetn)
  if (!resetn)
    counter2x <= {WIDTH{1'b0}};
  else if (agent_write)
    counter2x <= {WIDTH{1'b0}};
  else
    counter2x <= counter2x + 2'b01;

assign agent_waitrequest = 1'b0;
assign agent_readdata = (USE_2XCLK && clock_sel) ? counter2x : counter;
assign agent_readdatavalid = agent_read;

endmodule
