#!/bin/tcsh
#=========================================================================
# Copyright (C) 1999 Intel Corporation
#
# Licensed under the Apache License,  Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# 	http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law  or agreed  to  in  writing,  software
# distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the  specific  language  governing  permissions  and
# limitations under the License.
#=========================================================================

setenv IPPCRYPTOROOT `echo -n "$cwd" | head -c-4`

set __ippcp_tmp_target_arch=intel64
set __ippcp_tmp_target_platform=""

if ( $#argv == 0 ) then
  if ($?COMPILERVARS_ARCHITECTURE) then
    set __ippcp_tmp_target_arch=$COMPILERVARS_ARCHITECTURE
  endif
  if ($?COMPILERVARS_PLATFORM) then
    set __ippcp_tmp_target_platform=$COMPILERVARS_PLATFORM
  endif
endif

while ( "$1" != "" )
  if ( "$1" == "ia32" || "$1" == "intel64" ) then
    set __ippcp_tmp_target_arch="$1"
  endif
  shift
end

if ( "$__ippcp_tmp_target_arch" == "ia32") \
then
  set __ippcp_tmp_target_lib_arch="lib32"
else
  set __ippcp_tmp_target_lib_arch="lib"
endif

if ( "$__ippcp_tmp_target_arch" != "ia32" && \
     "$__ippcp_tmp_target_arch" != "intel64" ) \
then
  echo "ERROR: architecture is not defined. Accepted values: ia32, intel64"
  goto Help
else

  if !($?CPATH) then
    setenv CPATH ${IPPCRYPTOROOT}/include
  else
    setenv CPATH ${IPPCRYPTOROOT}/include:${CPATH}
  endif

  setenv arch $__ippcp_tmp_target_arch
  setenv IPPCP_TARGET_ARCH=$__ippcp_tmp_target_arch

  if !($?LD_LIBRARY_PATH) then
    setenv LD_LIBRARY_PATH $IPPCRYPTOROOT/${__ippcp_tmp_target_lib_arch}
  else
    setenv LD_LIBRARY_PATH $IPPCRYPTOROOT/${__ippcp_tmp_target_lib_arch}:${LD_LIBRARY_PATH}
  endif

  if !($?LIBRARY_PATH) then
    setenv LIBRARY_PATH $IPPCRYPTOROOT/${__ippcp_tmp_target_lib_arch}
  else
    setenv LIBRARY_PATH $IPPCRYPTOROOT/${__ippcp_tmp_target_lib_arch}:${LIBRARY_PATH}
  endif
endif

goto End

Help:
  echo "Syntax: vars.csh <arch> [-arch <arch>] [-platform <platform>]"
  echo ""
  echo "  <arch> must be one of the following:"
  echo "      ia32           : Set up for IA-32 target."
  echo "      intel64        : Set up for Intel(R)64 target."
  echo "  <platform> must be of the following:"
  echo "      linux          : Set to Linux target."
  echo "      mac            : Set to Mac target."
  echo ""
  echo "If the arguments to the sourced script are ignored (consult docs"
  echo "for your shell) the alternative way to specify target is environment"
  echo "variables COMPILERVARS_ARCHITECTURE to pass <arch> to the script"
  echo "and COMPILERVARS_PLATFORM to pass <platform>"

  exit 1;

End:
  unset __ippcp_tmp_target_arch
  unset __ippcp_tmp_target_lib_arch
  unset __ippcp_tmp_target_platform
