/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.loader;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u00062\u00020\u0001:\u0004\u0006\u0007\b\tJ\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "", "check", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblemCase$PlatformCheckMismatch;", "library", "Lorg/jetbrains/kotlin/library/BaseKotlinLibrary;", "Companion", "JS", "Native", "Wasm", "kotlin-util-klib"})
public interface KlibPlatformChecker {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.library.loader.KlibPlatformChecker$Companion.$$INSTANCE;

    @Nullable
    public KlibLoaderResult.ProblemCase.PlatformCheckMismatch check(@NotNull BaseKotlinLibrary var1);

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J(\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker$Companion;", "", "()V", "checkPlatform", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblemCase$PlatformCheckMismatch;", "expectedPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "actualPlatform", "checkTarget", "platform", "expectedTarget", "", "actualTargets", "", "kotlin-util-klib"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        private final KlibLoaderResult.ProblemCase.PlatformCheckMismatch checkPlatform(BuiltInsPlatform expectedPlatform, BuiltInsPlatform actualPlatform) {
            if (actualPlatform == expectedPlatform) {
                return null;
            }
            String string = expectedPlatform.name();
            Object object = actualPlatform;
            if (object == null || (object = object.name()) == null) {
                object = "<unknown>";
            }
            return new KlibLoaderResult.ProblemCase.PlatformCheckMismatch("platform", string, (String)object);
        }

        private final KlibLoaderResult.ProblemCase.PlatformCheckMismatch checkTarget(BuiltInsPlatform platform, String expectedTarget, List<String> actualTargets) {
            if (actualTargets.contains(expectedTarget)) {
                return null;
            }
            return new KlibLoaderResult.ProblemCase.PlatformCheckMismatch("target", platform.name() + '[' + expectedTarget + ']', platform.name() + '[' + CollectionsKt.joinToString$default((Iterable)actualTargets, null, null, null, (int)0, null, null, (int)63, null) + ']');
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker$JS;", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "()V", "check", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblemCase$PlatformCheckMismatch;", "library", "Lorg/jetbrains/kotlin/library/BaseKotlinLibrary;", "kotlin-util-klib"})
    public static final class JS
    implements KlibPlatformChecker {
        @NotNull
        public static final JS INSTANCE = new JS();

        private JS() {
        }

        @Override
        @Nullable
        public KlibLoaderResult.ProblemCase.PlatformCheckMismatch check(@NotNull BaseKotlinLibrary library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            return Companion.checkPlatform(BuiltInsPlatform.JS, KotlinLibraryKt.getBuiltInsPlatform(library));
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker$Native;", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "target", "", "(Ljava/lang/String;)V", "check", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblemCase$PlatformCheckMismatch;", "library", "Lorg/jetbrains/kotlin/library/BaseKotlinLibrary;", "kotlin-util-klib"})
    public static final class Native
    implements KlibPlatformChecker {
        @Nullable
        private final String target;

        public Native(@Nullable String target) {
            this.target = target;
        }

        public /* synthetic */ Native(String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Override
        @Nullable
        public KlibLoaderResult.ProblemCase.PlatformCheckMismatch check(@NotNull BaseKotlinLibrary library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            KlibLoaderResult.ProblemCase.PlatformCheckMismatch platformMismatch = Companion.checkPlatform(BuiltInsPlatform.NATIVE, KotlinLibraryKt.getBuiltInsPlatform(library));
            if (platformMismatch != null) {
                return platformMismatch;
            }
            String string = this.target;
            if (string == null) {
                return null;
            }
            String expectedTarget = string;
            return Companion.checkTarget(BuiltInsPlatform.NATIVE, expectedTarget, KotlinLibraryKt.getNativeTargets(library));
        }

        public Native() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker$Wasm;", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "target", "", "(Ljava/lang/String;)V", "check", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblemCase$PlatformCheckMismatch;", "library", "Lorg/jetbrains/kotlin/library/BaseKotlinLibrary;", "kotlin-util-klib"})
    public static final class Wasm
    implements KlibPlatformChecker {
        @Nullable
        private final String target;

        public Wasm(@Nullable String target) {
            this.target = target;
        }

        public /* synthetic */ Wasm(String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Override
        @Nullable
        public KlibLoaderResult.ProblemCase.PlatformCheckMismatch check(@NotNull BaseKotlinLibrary library) {
            KlibLoaderResult.ProblemCase.PlatformCheckMismatch platformMismatch;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            KlibLoaderResult.ProblemCase.PlatformCheckMismatch platformCheckMismatch = platformMismatch = Companion.checkPlatform(BuiltInsPlatform.WASM, KotlinLibraryKt.getBuiltInsPlatform(library));
            if (platformCheckMismatch != null) {
                return platformCheckMismatch;
            }
            String string = this.target;
            if (string == null) {
                return null;
            }
            String expectedTarget = string;
            List<String> actualTargets = KotlinLibraryKt.getWasmTargets(library);
            if (actualTargets.isEmpty()) {
                KotlinAbiVersion kotlinAbiVersion = library.getVersions().getAbiVersion();
                boolean bl = kotlinAbiVersion != null ? kotlinAbiVersion.isAtMost(1, 8, 0) : false;
                if (bl) {
                    return null;
                }
            }
            return Companion.checkTarget(BuiltInsPlatform.WASM, expectedTarget, actualTargets);
        }

        public Wasm() {
            this(null, 1, null);
        }
    }
}

