/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class ConnectionPropertiesControl
extends PropertyTreeViewer {
    private static final Log log = Log.getLog(ConnectionPropertiesControl.class);
    private static final String USER_PROPERTIES_CATEGORY = UIConnectionMessages.controls_connection_properties_category_user_properties;
    private List<DBPPropertyDescriptor> driverProvidedProperties;
    private List<DBPPropertyDescriptor> customProperties;
    private static Comparator<DBPPropertyDescriptor> PROPERTIES_COMPARATOR = Comparator.comparing(DBPPropertyDescriptor::getDisplayName);

    public ConnectionPropertiesControl(Composite parent, int style) {
        super(parent, style);
        this.setExpandSingleRoot(false);
        this.setNewPropertiesAllowed(true);
    }

    PropertySourceCustom makeProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo, @Nullable DBPDriverSubstitutionDescriptor driverSubstitution) {
        HashMap connectionProps = new HashMap();
        connectionProps.putAll(driver.getConnectionProperties());
        connectionProps.putAll(connectionInfo.getProperties());
        this.driverProvidedProperties = null;
        this.customProperties = null;
        if (driverSubstitution == null) {
            this.loadDriverProperties(monitor, driver, connectionInfo);
        }
        this.loadCustomProperties(driver, connectionProps);
        return new PropertySourceCustom(this.getAllProperties(driver, true), connectionProps);
    }

    public PropertySourceCustom makeProperties(DBPDriver driver, Map<String, ?> properties) {
        this.driverProvidedProperties = null;
        this.customProperties = null;
        this.loadCustomProperties(driver, properties);
        return new PropertySourceCustom(this.getAllProperties(driver, true), properties);
    }

    protected String[] getCustomCategories() {
        return new String[]{USER_PROPERTIES_CATEGORY};
    }

    protected void contributeContextMenu(IMenuManager manager, final Object node, final String category, DBPPropertyDescriptor property) {
        boolean isCustom = USER_PROPERTIES_CATEGORY.equals(category);
        if (isCustom) {
            manager.add((IAction)new Action(this, UIConnectionMessages.controls_connection_properties_action_add_property){
                final /* synthetic */ ConnectionPropertiesControl this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                public void run() {
                    this.this$0.createNewProperty(node, category);
                }
            });
            if (property != null) {
                manager.add((IAction)new Action(this, UIConnectionMessages.controls_connection_properties_action_remove_property){
                    final /* synthetic */ ConnectionPropertiesControl this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    public void run() {
                        this.this$0.removeProperty(node);
                    }
                });
            }
        }
    }

    protected boolean isHidePropertyValue(DBPPropertyDescriptor property) {
        Class dataType = property.getDataType();
        if (dataType != null && !String.class.isAssignableFrom(dataType)) {
            return false;
        }
        String propName = CommonUtils.toString((Object)property.getId()).toLowerCase(Locale.ENGLISH);
        return propName.contains("password") || propName.contains("token");
    }

    private void createNewProperty(Object node, String category) {
        String propName = EnterNameDialog.chooseName((Shell)this.getControl().getShell(), (String)UIConnectionMessages.controls_connection_properties_dialog_new_property_title);
        if (propName != null) {
            this.addProperty(node, (DBPPropertyDescriptor)new PropertyDescriptor(category, propName, propName, null, null, false, null, null, true), true);
        }
    }

    private List<DBPPropertyDescriptor> getAllProperties(DBPDriver driver, boolean includeCustom) {
        ArrayList<DBPPropertyDescriptor> propertyDescriptors = new ArrayList<DBPPropertyDescriptor>();
        if (this.driverProvidedProperties != null) {
            propertyDescriptors.addAll(this.driverProvidedProperties);
        }
        if (includeCustom && this.customProperties != null) {
            propertyDescriptors.addAll(this.customProperties);
        }
        propertyDescriptors.sort(PROPERTIES_COMPARATOR);
        return propertyDescriptors;
    }

    private void loadDriverProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        try {
            DBPPropertyDescriptor[] connectionsProps = driver.getDataSourceProvider().getConnectionProperties(monitor, driver, connectionInfo);
            this.driverProvidedProperties = new ArrayList<DBPPropertyDescriptor>();
            if (connectionsProps != null) {
                Collections.addAll(this.driverProvidedProperties, connectionsProps);
            }
        }
        catch (DBException e) {
            log.warn((Object)"Can't load driver properties", (Throwable)e);
        }
    }

    private void loadCustomProperties(DBPDriver driver, Map<?, ?> properties) {
        TreeSet<String> propNames = new TreeSet<String>();
        List<DBPPropertyDescriptor> allProperties = this.getAllProperties(driver, false);
        for (DBPPropertyDescriptor prop : allProperties) {
            propNames.add(CommonUtils.toString((Object)prop.getId()));
        }
        this.customProperties = new ArrayList<DBPPropertyDescriptor>();
        for (Object propId : properties.keySet()) {
            String propName = propId.toString();
            if (propNames.contains(propName)) continue;
            this.customProperties.add((DBPPropertyDescriptor)new PropertyDescriptor(USER_PROPERTIES_CATEGORY, propName, propName, null, String.class, false, null, null, true));
        }
        this.customProperties.sort(PROPERTIES_COMPARATOR);
    }

    void createPropertiesToolBar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 256);
        GridData gd = new GridData(32);
        toolBar.setLayoutData((Object)gd);
        ToolItem addItem = new ToolItem(toolBar, 0);
        addItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD));
        addItem.setToolTipText("Add user property");
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPropertiesControl.this.createNewProperty(ConnectionPropertiesControl.this.getCategoryNode(USER_PROPERTIES_CATEGORY), USER_PROPERTIES_CATEGORY);
            }
        });
        ToolItem removeItem = new ToolItem(toolBar, 0);
        removeItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE));
        removeItem.setToolTipText("Remove user property");
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ConnectionPropertiesControl.this.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    ConnectionPropertiesControl.this.removeProperty(((IStructuredSelection)selection).getFirstElement());
                }
            }
        });
        removeItem.setEnabled(false);
        this.addSelectionChangedListener(event -> {
            addItem.setEnabled(this.getCategoryNode(USER_PROPERTIES_CATEGORY) != null);
            boolean hasDelete = false;
            if (USER_PROPERTIES_CATEGORY.equals(this.getSelectedCategory())) {
                hasDelete = true;
            }
            removeItem.setEnabled(hasDelete);
        });
    }
}

