/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataBulkLoader;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreCopyLoader
implements DBSDataBulkLoader,
DBSDataBulkLoader.BulkLoadManager {
    private static final Log log = Log.getLog(PostgreCopyLoader.class);
    private final PostgreDataSource dataSource;
    private PostgreTableReal table;
    private Object copyManager;
    private Method copyInMethod;
    private Writer csvWriter;
    private Path csvFile;
    private AttrMapping[] mappings;
    private int copyBufferSize = 102400;

    public PostgreCopyLoader(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBSDataBulkLoader.BulkLoadManager createBulkLoad(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBSAttributeBase[] attributes, @NotNull DBCExecutionSource source, int batchSize, @NotNull Map<String, Object> options) throws DBCException {
        this.table = (PostgreTableReal)dataContainer;
        try {
            Connection pgConnection = ((JDBCSession)session).getOriginal();
            ClassLoader driverClassLoader = pgConnection.getClass().getClassLoader();
            Class<?> baseConnectionClass = Class.forName("org.postgresql.core.BaseConnection", true, driverClassLoader);
            Class<?> copyManagerClass = Class.forName("org.postgresql.copy.CopyManager", true, driverClassLoader);
            this.copyInMethod = copyManagerClass.getMethod("copyIn", String.class, Reader.class, Integer.TYPE);
            this.copyManager = copyManagerClass.getConstructor(baseConnectionClass).newInstance(pgConnection);
            Path tempFolder = DBWorkbench.getPlatform().getTempFolder(session.getProgressMonitor(), "postgesql-copy-datasets");
            this.csvFile = tempFolder.resolve(CommonUtils.escapeFileName((String)this.table.getFullyQualifiedName(DBPEvaluationContext.DML)) + "-" + System.currentTimeMillis() + ".csv");
            try {
                Files.createFile(this.csvFile, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IOException("Can't create CSV file " + String.valueOf(this.csvFile));
            }
            this.csvWriter = new BufferedWriter(Files.newBufferedWriter(this.csvFile, StandardCharsets.UTF_8, new OpenOption[0]), this.copyBufferSize);
            List tableAttrs = CommonUtils.safeList(this.table.getAttributes(session.getProgressMonitor()));
            tableAttrs.removeIf(a -> a.getOrdinalPosition() < 0);
            this.mappings = new AttrMapping[tableAttrs.size()];
            for (int i = 0; i < tableAttrs.size(); ++i) {
                AttrMapping mapping;
                PostgreTableColumn attr = (PostgreTableColumn)tableAttrs.get(i);
                DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)attr);
                this.mappings[i] = mapping = new AttrMapping(attr, valueHandler, ArrayUtils.indexOf((Object[])attributes, (Object)attr));
            }
        }
        catch (Exception e) {
            throw new DBCException("Can't instantiate CopyManager", (Throwable)e);
        }
        return this;
    }

    public void addRow(@NotNull DBCSession session, @NotNull Object[] attributeValues) throws DBCException {
        StringBuilder line = new StringBuilder();
        boolean hasCell = false;
        for (AttrMapping mapping : this.mappings) {
            Object srcValue;
            if (mapping.srcPos < 0) continue;
            if (hasCell) {
                line.append(",");
            }
            if (!DBUtils.isNullValue((Object)(srcValue = attributeValues[mapping.srcPos]))) {
                if (srcValue instanceof Number) {
                    line.append(srcValue);
                } else {
                    String strValue = mapping.valueHandler.getValueDisplayString((DBSTypedObject)mapping.tableAttr, srcValue, DBDDisplayFormat.NATIVE);
                    strValue = this.convertStringValueToCell(strValue);
                    line.append(strValue);
                }
            }
            hasCell = true;
        }
        line.append("\n");
        try {
            this.csvWriter.write(line.toString());
        }
        catch (IOException e) {
            throw new DBCException("Error writing CSV line", (Throwable)e);
        }
    }

    private String convertStringValueToCell(String strValue) {
        return "\"" + strValue.replace("\"", "\\\"") + "\"";
    }

    public void flushRows(@NotNull DBCSession session) throws DBCException {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            throw new DBCException("Error saving CSV data", (Throwable)e);
        }
    }

    public void finishBulkLoad(@NotNull DBCSession session) throws DBCException {
        try {
            this.csvWriter.flush();
            this.csvWriter.close();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        this.csvWriter = null;
        String tableFQN = this.table.getFullyQualifiedName(DBPEvaluationContext.DML);
        session.getProgressMonitor().subTask("Copy into " + tableFQN);
        String queryText = "COPY " + tableFQN + " FROM STDIN (FORMAT CSV, ESCAPE '\\')";
        try {
            Object rowCount;
            try (BufferedReader csvReader = Files.newBufferedReader(this.csvFile, StandardCharsets.UTF_8);){
                rowCount = this.copyInMethod.invoke(this.copyManager, queryText, csvReader, this.copyBufferSize);
            }
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && !txnManager.isAutoCommit()) {
                session.getProgressMonitor().subTask("Commit COPY");
                txnManager.commit(session);
            }
            log.debug((Object)("CSV has been imported (" + String.valueOf(rowCount) + ")"));
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new DBCException("Error copying dataset on remote server", e);
        }
    }

    public void close() {
        if (this.csvFile != null && Files.exists(this.csvFile, new LinkOption[0])) {
            try {
                Files.delete(this.csvFile);
            }
            catch (IOException e) {
                log.debug((Object)("Error deleting CSV file " + String.valueOf(this.csvFile)), (Throwable)e);
                this.csvFile.toFile().deleteOnExit();
            }
        }
    }

    private static class AttrMapping {
        PostgreTableColumn tableAttr;
        DBDValueHandler valueHandler;
        int srcPos;

        AttrMapping(PostgreTableColumn tableAttr, DBDValueHandler valueHandler, int srcPos) {
            this.tableAttr = tableAttr;
            this.valueHandler = valueHandler;
            this.srcPos = srcPos;
        }
    }
}

