/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.merge;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.merge.MergeOperation;
import net.sf.jsqlparser.statement.merge.MergeOperationVisitor;

public class MergeInsert
implements Serializable,
MergeOperation {
    private Expression andPredicate;
    private ExpressionList<Column> columns;
    private ExpressionList<Expression> values;
    private Expression whereCondition;

    public Expression getAndPredicate() {
        return this.andPredicate;
    }

    public void setAndPredicate(Expression andPredicate) {
        this.andPredicate = andPredicate;
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> columns) {
        this.columns = columns;
    }

    public ExpressionList<Expression> getValues() {
        return this.values;
    }

    public void setValues(ExpressionList<Expression> values) {
        this.values = values;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression whereCondition) {
        this.whereCondition = whereCondition;
    }

    @Override
    public <S, T> T accept(MergeOperationVisitor<T> mergeOperationVisitor, S context) {
        return mergeOperationVisitor.visit(this, context);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(" WHEN NOT MATCHED");
        if (this.andPredicate != null) {
            b.append(" AND ").append(this.andPredicate.toString());
        }
        b.append(" THEN INSERT ");
        if (this.columns != null) {
            b.append(this.columns.toString());
        }
        b.append(" VALUES ").append(this.values.toString());
        if (this.whereCondition != null) {
            b.append(" WHERE ").append(this.whereCondition.toString());
        }
        return b.toString();
    }

    public MergeInsert withAndPredicate(Expression andPredicate) {
        this.setAndPredicate(andPredicate);
        return this;
    }

    public MergeInsert withColumns(ExpressionList<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public MergeInsert withValues(ExpressionList<Expression> values) {
        this.setValues(values);
        return this;
    }

    public MergeInsert addColumns(Column ... columns) {
        return this.addColumns(Arrays.asList(columns));
    }

    public MergeInsert addColumns(Collection<? extends Column> columns) {
        ExpressionList collection = Optional.ofNullable(this.getColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public MergeInsert addValues(Expression ... values) {
        return this.addValues(Arrays.asList(values));
    }

    public MergeInsert addValues(Collection<? extends Expression> values) {
        ExpressionList collection = Optional.ofNullable(this.getValues()).orElseGet(() -> new ExpressionList(new Expression[0]));
        collection.addAll(values);
        return this.withValues(collection);
    }

    public MergeInsert withWhereCondition(Expression whereCondition) {
        this.setWhereCondition(whereCondition);
        return this;
    }

    public <E extends Expression> E getAndPredicate(Class<E> type) {
        return (E)((Expression)type.cast(this.getAndPredicate()));
    }

    public <E extends Expression> E getWhereCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhereCondition()));
    }
}

