/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferencePage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class DataSourcePageDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataSourcePageDescriptor.class);
    private final String id;
    private final String parentId;
    private final String afterPageId;
    private final String title;
    private final String description;
    private final AbstractDescriptor.ObjectType pageClass;
    private Expression enablementExpression;

    public DataSourcePageDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        this.id = config.getAttribute("id");
        this.parentId = config.getAttribute("parent");
        this.afterPageId = config.getAttribute("after");
        this.title = config.getAttribute("title");
        this.description = config.getAttribute("description");
        this.pageClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.enablementExpression = DataSourcePageDescriptor.getEnablementExpression((IConfigurationElement)config);
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getAfterPageId() {
        return this.afterPageId;
    }

    public String getTitle() {
        return this.title == null ? this.id : this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public AbstractDescriptor.ObjectType getPageClass() {
        return this.pageClass;
    }

    public IPreferencePage createPage() {
        try {
            return (IPreferencePage)this.pageClass.createInstance(IPreferencePage.class);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't create preferences page '" + this.id + "'", ex);
        }
    }

    public boolean appliesTo(DBPDataSourceContainer dataSource) {
        return DataSourcePageDescriptor.isExpressionTrue((Expression)this.enablementExpression, (Object)dataSource);
    }

    public String toString() {
        return this.id;
    }
}

