﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/ImportLensStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {
class ImportLensResult {
 public:
  AWS_WELLARCHITECTED_API ImportLensResult() = default;
  AWS_WELLARCHITECTED_API ImportLensResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WELLARCHITECTED_API ImportLensResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN for the lens that was created or updated.</p>
   */
  inline const Aws::String& GetLensArn() const { return m_lensArn; }
  template <typename LensArnT = Aws::String>
  void SetLensArn(LensArnT&& value) {
    m_lensArnHasBeenSet = true;
    m_lensArn = std::forward<LensArnT>(value);
  }
  template <typename LensArnT = Aws::String>
  ImportLensResult& WithLensArn(LensArnT&& value) {
    SetLensArn(std::forward<LensArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the imported lens.</p>
   */
  inline ImportLensStatus GetStatus() const { return m_status; }
  inline void SetStatus(ImportLensStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ImportLensResult& WithStatus(ImportLensStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ImportLensResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_lensArn;

  ImportLensStatus m_status{ImportLensStatus::NOT_SET};

  Aws::String m_requestId;
  bool m_lensArnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
