﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/SWF_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SWF {
namespace Model {

/**
 * <p>Provides the details of the <code>LambdaFunctionCompleted</code> event. It
 * isn't set for other event types.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/LambdaFunctionCompletedEventAttributes">AWS
 * API Reference</a></p>
 */
class LambdaFunctionCompletedEventAttributes {
 public:
  AWS_SWF_API LambdaFunctionCompletedEventAttributes() = default;
  AWS_SWF_API LambdaFunctionCompletedEventAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API LambdaFunctionCompletedEventAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the <code>LambdaFunctionScheduled</code> event that was recorded
   * when this Lambda task was scheduled. To help diagnose issues, use this
   * information to trace back the chain of events leading up to this event.</p>
   */
  inline long long GetScheduledEventId() const { return m_scheduledEventId; }
  inline bool ScheduledEventIdHasBeenSet() const { return m_scheduledEventIdHasBeenSet; }
  inline void SetScheduledEventId(long long value) {
    m_scheduledEventIdHasBeenSet = true;
    m_scheduledEventId = value;
  }
  inline LambdaFunctionCompletedEventAttributes& WithScheduledEventId(long long value) {
    SetScheduledEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>LambdaFunctionStarted</code> event recorded when this
   * activity task started. To help diagnose issues, use this information to trace
   * back the chain of events leading up to this event.</p>
   */
  inline long long GetStartedEventId() const { return m_startedEventId; }
  inline bool StartedEventIdHasBeenSet() const { return m_startedEventIdHasBeenSet; }
  inline void SetStartedEventId(long long value) {
    m_startedEventIdHasBeenSet = true;
    m_startedEventId = value;
  }
  inline LambdaFunctionCompletedEventAttributes& WithStartedEventId(long long value) {
    SetStartedEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The results of the Lambda task.</p>
   */
  inline const Aws::String& GetResult() const { return m_result; }
  inline bool ResultHasBeenSet() const { return m_resultHasBeenSet; }
  template <typename ResultT = Aws::String>
  void SetResult(ResultT&& value) {
    m_resultHasBeenSet = true;
    m_result = std::forward<ResultT>(value);
  }
  template <typename ResultT = Aws::String>
  LambdaFunctionCompletedEventAttributes& WithResult(ResultT&& value) {
    SetResult(std::forward<ResultT>(value));
    return *this;
  }
  ///@}
 private:
  long long m_scheduledEventId{0};

  long long m_startedEventId{0};

  Aws::String m_result;
  bool m_scheduledEventIdHasBeenSet = false;
  bool m_startedEventIdHasBeenSet = false;
  bool m_resultHasBeenSet = false;
};

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
