﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/scheduler/Scheduler_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Scheduler {
namespace Model {
class CreateScheduleGroupResult {
 public:
  AWS_SCHEDULER_API CreateScheduleGroupResult() = default;
  AWS_SCHEDULER_API CreateScheduleGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SCHEDULER_API CreateScheduleGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the schedule group.</p>
   */
  inline const Aws::String& GetScheduleGroupArn() const { return m_scheduleGroupArn; }
  template <typename ScheduleGroupArnT = Aws::String>
  void SetScheduleGroupArn(ScheduleGroupArnT&& value) {
    m_scheduleGroupArnHasBeenSet = true;
    m_scheduleGroupArn = std::forward<ScheduleGroupArnT>(value);
  }
  template <typename ScheduleGroupArnT = Aws::String>
  CreateScheduleGroupResult& WithScheduleGroupArn(ScheduleGroupArnT&& value) {
    SetScheduleGroupArn(std::forward<ScheduleGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateScheduleGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scheduleGroupArn;

  Aws::String m_requestId;
  bool m_scheduleGroupArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Scheduler
}  // namespace Aws
