﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class SendPipelineExecutionStepFailureResult {
 public:
  AWS_SAGEMAKER_API SendPipelineExecutionStepFailureResult() = default;
  AWS_SAGEMAKER_API SendPipelineExecutionStepFailureResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API SendPipelineExecutionStepFailureResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
   */
  inline const Aws::String& GetPipelineExecutionArn() const { return m_pipelineExecutionArn; }
  template <typename PipelineExecutionArnT = Aws::String>
  void SetPipelineExecutionArn(PipelineExecutionArnT&& value) {
    m_pipelineExecutionArnHasBeenSet = true;
    m_pipelineExecutionArn = std::forward<PipelineExecutionArnT>(value);
  }
  template <typename PipelineExecutionArnT = Aws::String>
  SendPipelineExecutionStepFailureResult& WithPipelineExecutionArn(PipelineExecutionArnT&& value) {
    SetPipelineExecutionArn(std::forward<PipelineExecutionArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SendPipelineExecutionStepFailureResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_pipelineExecutionArn;

  Aws::String m_requestId;
  bool m_pipelineExecutionArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
