﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class DescribePipelineDefinitionForExecutionResult {
 public:
  AWS_SAGEMAKER_API DescribePipelineDefinitionForExecutionResult() = default;
  AWS_SAGEMAKER_API DescribePipelineDefinitionForExecutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API DescribePipelineDefinitionForExecutionResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The JSON pipeline definition.</p>
   */
  inline const Aws::String& GetPipelineDefinition() const { return m_pipelineDefinition; }
  template <typename PipelineDefinitionT = Aws::String>
  void SetPipelineDefinition(PipelineDefinitionT&& value) {
    m_pipelineDefinitionHasBeenSet = true;
    m_pipelineDefinition = std::forward<PipelineDefinitionT>(value);
  }
  template <typename PipelineDefinitionT = Aws::String>
  DescribePipelineDefinitionForExecutionResult& WithPipelineDefinition(PipelineDefinitionT&& value) {
    SetPipelineDefinition(std::forward<PipelineDefinitionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the pipeline was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribePipelineDefinitionForExecutionResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribePipelineDefinitionForExecutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_pipelineDefinition;

  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_requestId;
  bool m_pipelineDefinitionHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
