﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pricing/Pricing_EXPORTS.h>
#include <aws/pricing/model/Service.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Pricing {
namespace Model {
class DescribeServicesResult {
 public:
  AWS_PRICING_API DescribeServicesResult() = default;
  AWS_PRICING_API DescribeServicesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PRICING_API DescribeServicesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The service metadata for the service or services in the response.</p>
   */
  inline const Aws::Vector<Service>& GetServices() const { return m_services; }
  template <typename ServicesT = Aws::Vector<Service>>
  void SetServices(ServicesT&& value) {
    m_servicesHasBeenSet = true;
    m_services = std::forward<ServicesT>(value);
  }
  template <typename ServicesT = Aws::Vector<Service>>
  DescribeServicesResult& WithServices(ServicesT&& value) {
    SetServices(std::forward<ServicesT>(value));
    return *this;
  }
  template <typename ServicesT = Service>
  DescribeServicesResult& AddServices(ServicesT&& value) {
    m_servicesHasBeenSet = true;
    m_services.emplace_back(std::forward<ServicesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The format version of the response. For example, <code>aws_v1</code>.</p>
   */
  inline const Aws::String& GetFormatVersion() const { return m_formatVersion; }
  template <typename FormatVersionT = Aws::String>
  void SetFormatVersion(FormatVersionT&& value) {
    m_formatVersionHasBeenSet = true;
    m_formatVersion = std::forward<FormatVersionT>(value);
  }
  template <typename FormatVersionT = Aws::String>
  DescribeServicesResult& WithFormatVersion(FormatVersionT&& value) {
    SetFormatVersion(std::forward<FormatVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token for the next set of retrievable results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeServicesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeServicesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Service> m_services;

  Aws::String m_formatVersion;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_servicesHasBeenSet = false;
  bool m_formatVersionHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pricing
}  // namespace Aws
