﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/CaptionSelectorSettings.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaLive {
namespace Model {

/**
 * Caption Selector<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CaptionSelector">AWS
 * API Reference</a></p>
 */
class CaptionSelector {
 public:
  AWS_MEDIALIVE_API CaptionSelector() = default;
  AWS_MEDIALIVE_API CaptionSelector(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API CaptionSelector& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * When specified this field indicates the three letter language code of the
   * caption track to extract from the source.
   */
  inline const Aws::String& GetLanguageCode() const { return m_languageCode; }
  inline bool LanguageCodeHasBeenSet() const { return m_languageCodeHasBeenSet; }
  template <typename LanguageCodeT = Aws::String>
  void SetLanguageCode(LanguageCodeT&& value) {
    m_languageCodeHasBeenSet = true;
    m_languageCode = std::forward<LanguageCodeT>(value);
  }
  template <typename LanguageCodeT = Aws::String>
  CaptionSelector& WithLanguageCode(LanguageCodeT&& value) {
    SetLanguageCode(std::forward<LanguageCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Name identifier for a caption selector.  This name is used to associate this
   * caption selector with one or more caption descriptions.  Names must be unique
   * within an event.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CaptionSelector& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Caption selector settings.
   */
  inline const CaptionSelectorSettings& GetSelectorSettings() const { return m_selectorSettings; }
  inline bool SelectorSettingsHasBeenSet() const { return m_selectorSettingsHasBeenSet; }
  template <typename SelectorSettingsT = CaptionSelectorSettings>
  void SetSelectorSettings(SelectorSettingsT&& value) {
    m_selectorSettingsHasBeenSet = true;
    m_selectorSettings = std::forward<SelectorSettingsT>(value);
  }
  template <typename SelectorSettingsT = CaptionSelectorSettings>
  CaptionSelector& WithSelectorSettings(SelectorSettingsT&& value) {
    SetSelectorSettings(std::forward<SelectorSettingsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_languageCode;

  Aws::String m_name;

  CaptionSelectorSettings m_selectorSettings;
  bool m_languageCodeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_selectorSettingsHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
