﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kendra/Kendra_EXPORTS.h>
#include <aws/kendra/model/DocumentStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace kendra {
namespace Model {

/**
 * <p>Provides information about the status of documents submitted for
 * indexing.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Status">AWS API
 * Reference</a></p>
 */
class Status {
 public:
  AWS_KENDRA_API Status() = default;
  AWS_KENDRA_API Status(Aws::Utils::Json::JsonView jsonValue);
  AWS_KENDRA_API Status& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_KENDRA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the document.</p>
   */
  inline const Aws::String& GetDocumentId() const { return m_documentId; }
  inline bool DocumentIdHasBeenSet() const { return m_documentIdHasBeenSet; }
  template <typename DocumentIdT = Aws::String>
  void SetDocumentId(DocumentIdT&& value) {
    m_documentIdHasBeenSet = true;
    m_documentId = std::forward<DocumentIdT>(value);
  }
  template <typename DocumentIdT = Aws::String>
  Status& WithDocumentId(DocumentIdT&& value) {
    SetDocumentId(std::forward<DocumentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of a document.</p> <p>If the document was submitted for
   * deletion, the status is <code>NOT_FOUND</code> after the document is
   * deleted.</p>
   */
  inline DocumentStatus GetDocumentStatus() const { return m_documentStatus; }
  inline bool DocumentStatusHasBeenSet() const { return m_documentStatusHasBeenSet; }
  inline void SetDocumentStatus(DocumentStatus value) {
    m_documentStatusHasBeenSet = true;
    m_documentStatus = value;
  }
  inline Status& WithDocumentStatus(DocumentStatus value) {
    SetDocumentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates the source of the error.</p>
   */
  inline const Aws::String& GetFailureCode() const { return m_failureCode; }
  inline bool FailureCodeHasBeenSet() const { return m_failureCodeHasBeenSet; }
  template <typename FailureCodeT = Aws::String>
  void SetFailureCode(FailureCodeT&& value) {
    m_failureCodeHasBeenSet = true;
    m_failureCode = std::forward<FailureCodeT>(value);
  }
  template <typename FailureCodeT = Aws::String>
  Status& WithFailureCode(FailureCodeT&& value) {
    SetFailureCode(std::forward<FailureCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Provides detailed information about why the document couldn't be indexed. Use
   * this information to correct the error before you resubmit the document for
   * indexing.</p>
   */
  inline const Aws::String& GetFailureReason() const { return m_failureReason; }
  inline bool FailureReasonHasBeenSet() const { return m_failureReasonHasBeenSet; }
  template <typename FailureReasonT = Aws::String>
  void SetFailureReason(FailureReasonT&& value) {
    m_failureReasonHasBeenSet = true;
    m_failureReason = std::forward<FailureReasonT>(value);
  }
  template <typename FailureReasonT = Aws::String>
  Status& WithFailureReason(FailureReasonT&& value) {
    SetFailureReason(std::forward<FailureReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_documentId;

  DocumentStatus m_documentStatus{DocumentStatus::NOT_SET};

  Aws::String m_failureCode;

  Aws::String m_failureReason;
  bool m_documentIdHasBeenSet = false;
  bool m_documentStatusHasBeenSet = false;
  bool m_failureCodeHasBeenSet = false;
  bool m_failureReasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace kendra
}  // namespace Aws
