﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs-realtime/Ivsrealtime_EXPORTS.h>

namespace Aws {
namespace ivsrealtime {
namespace Model {
enum class PipBehavior { NOT_SET, STATIC_, DYNAMIC };

namespace PipBehaviorMapper {
AWS_IVSREALTIME_API PipBehavior GetPipBehaviorForName(const Aws::String& name);

AWS_IVSREALTIME_API Aws::String GetNameForPipBehavior(PipBehavior value);
}  // namespace PipBehaviorMapper
}  // namespace Model
}  // namespace ivsrealtime
}  // namespace Aws
