﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/greengrass/GreengrassRequest.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Greengrass {
namespace Model {

/**
 */
class UpdateDeviceDefinitionRequest : public GreengrassRequest {
 public:
  AWS_GREENGRASS_API UpdateDeviceDefinitionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateDeviceDefinition"; }

  AWS_GREENGRASS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * The ID of the device definition.
   */
  inline const Aws::String& GetDeviceDefinitionId() const { return m_deviceDefinitionId; }
  inline bool DeviceDefinitionIdHasBeenSet() const { return m_deviceDefinitionIdHasBeenSet; }
  template <typename DeviceDefinitionIdT = Aws::String>
  void SetDeviceDefinitionId(DeviceDefinitionIdT&& value) {
    m_deviceDefinitionIdHasBeenSet = true;
    m_deviceDefinitionId = std::forward<DeviceDefinitionIdT>(value);
  }
  template <typename DeviceDefinitionIdT = Aws::String>
  UpdateDeviceDefinitionRequest& WithDeviceDefinitionId(DeviceDefinitionIdT&& value) {
    SetDeviceDefinitionId(std::forward<DeviceDefinitionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The name of the definition.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateDeviceDefinitionRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_deviceDefinitionId;

  Aws::String m_name;
  bool m_deviceDefinitionIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
