﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/devicefarm/model/Project.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DeviceFarm {
namespace Model {
/**
 * <p>Represents the result of a list projects request.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjectsResult">AWS
 * API Reference</a></p>
 */
class ListProjectsResult {
 public:
  AWS_DEVICEFARM_API ListProjectsResult() = default;
  AWS_DEVICEFARM_API ListProjectsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DEVICEFARM_API ListProjectsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the projects.</p>
   */
  inline const Aws::Vector<Project>& GetProjects() const { return m_projects; }
  template <typename ProjectsT = Aws::Vector<Project>>
  void SetProjects(ProjectsT&& value) {
    m_projectsHasBeenSet = true;
    m_projects = std::forward<ProjectsT>(value);
  }
  template <typename ProjectsT = Aws::Vector<Project>>
  ListProjectsResult& WithProjects(ProjectsT&& value) {
    SetProjects(std::forward<ProjectsT>(value));
    return *this;
  }
  template <typename ProjectsT = Project>
  ListProjectsResult& AddProjects(ProjectsT&& value) {
    m_projectsHasBeenSet = true;
    m_projects.emplace_back(std::forward<ProjectsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the number of items that are returned is significantly large, this is an
   * identifier that is also returned. It can be used in a subsequent call to this
   * operation to return the next set of items in the list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListProjectsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListProjectsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Project> m_projects;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_projectsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DeviceFarm
}  // namespace Aws
