/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.transport.model;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesRequest;

public class ReadDirectQueryResourcesActionRequest
extends ActionRequest {
    private final GetDirectQueryResourcesRequest directQueryRequest;

    public ReadDirectQueryResourcesActionRequest(GetDirectQueryResourcesRequest directQueryRequest) {
        this.directQueryRequest = directQueryRequest;
    }

    public ReadDirectQueryResourcesActionRequest(StreamInput in) throws IOException {
        GetDirectQueryResourcesRequest request = new GetDirectQueryResourcesRequest();
        request.setDataSource(in.readOptionalString());
        String resourceTypeStr = in.readOptionalString();
        if (resourceTypeStr != null) {
            request.setResourceTypeFromString(resourceTypeStr);
        }
        request.setResourceName(in.readOptionalString());
        request.setQueryParams(in.readMap(StreamInput::readString, StreamInput::readString));
        this.directQueryRequest = request;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.directQueryRequest.getDataSource());
        out.writeOptionalString(this.directQueryRequest.getResourceType() != null ? this.directQueryRequest.getResourceType().name() : null);
        out.writeOptionalString(this.directQueryRequest.getResourceName());
        out.writeMap(this.directQueryRequest.getQueryParams(), StreamOutput::writeString, StreamOutput::writeString);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    @Generated
    public GetDirectQueryResourcesRequest getDirectQueryRequest() {
        return this.directQueryRequest;
    }
}

