/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ReadShareGroupStateSummaryResponseDataJsonConverter {
    public static ReadShareGroupStateSummaryResponseData read(JsonNode _node, short _version) {
        ReadShareGroupStateSummaryResponseData _object = new ReadShareGroupStateSummaryResponseData();
        JsonNode _resultsNode = _node.get("results");
        if (_resultsNode == null) {
            throw new RuntimeException("ReadShareGroupStateSummaryResponseData: unable to locate field 'results', which is mandatory in version " + _version);
        }
        if (!_resultsNode.isArray()) {
            throw new RuntimeException("ReadShareGroupStateSummaryResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult> _collection = new ArrayList<ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult>(_resultsNode.size());
        _object.results = _collection;
        for (JsonNode _element : _resultsNode) {
            _collection.add(ReadStateSummaryResultJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ReadShareGroupStateSummaryResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _resultsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult _element : _object.results) {
            _resultsArray.add(ReadStateSummaryResultJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("results", (JsonNode)_resultsArray);
        return _node;
    }

    public static JsonNode write(ReadShareGroupStateSummaryResponseData _object, short _version) {
        return ReadShareGroupStateSummaryResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class ReadStateSummaryResultJsonConverter {
        public static ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult read(JsonNode _node, short _version) {
            ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult _object = new ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("ReadStateSummaryResult: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("ReadStateSummaryResult expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ReadStateSummaryResult: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ReadStateSummaryResult expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ReadShareGroupStateSummaryResponseData.PartitionResult> _collection = new ArrayList<ReadShareGroupStateSummaryResponseData.PartitionResult>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionResultJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ReadShareGroupStateSummaryResponseData.PartitionResult _element : _object.partitions) {
                _partitionsArray.add(PartitionResultJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult _object, short _version) {
            return ReadStateSummaryResultJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionResultJsonConverter {
        public static ReadShareGroupStateSummaryResponseData.PartitionResult read(JsonNode _node, short _version) {
            ReadShareGroupStateSummaryResponseData.PartitionResult _object = new ReadShareGroupStateSummaryResponseData.PartitionResult();
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'partition', which is mandatory in version " + _version);
            }
            _object.partition = MessageUtil.jsonNodeToInt(_partitionNode, "PartitionResult");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "PartitionResult");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("PartitionResult expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _stateEpochNode = _node.get("stateEpoch");
            if (_stateEpochNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'stateEpoch', which is mandatory in version " + _version);
            }
            _object.stateEpoch = MessageUtil.jsonNodeToInt(_stateEpochNode, "PartitionResult");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionResult");
            JsonNode _startOffsetNode = _node.get("startOffset");
            if (_startOffsetNode == null) {
                throw new RuntimeException("PartitionResult: unable to locate field 'startOffset', which is mandatory in version " + _version);
            }
            _object.startOffset = MessageUtil.jsonNodeToLong(_startOffsetNode, "PartitionResult");
            JsonNode _deliveryCompleteCountNode = _node.get("deliveryCompleteCount");
            if (_deliveryCompleteCountNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("PartitionResult: unable to locate field 'deliveryCompleteCount', which is mandatory in version " + _version);
                }
                _object.deliveryCompleteCount = -1;
            } else {
                _object.deliveryCompleteCount = MessageUtil.jsonNodeToInt(_deliveryCompleteCountNode, "PartitionResult");
            }
            return _object;
        }

        public static JsonNode write(ReadShareGroupStateSummaryResponseData.PartitionResult _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partition", (JsonNode)new IntNode(_object.partition));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            _node.set("stateEpoch", (JsonNode)new IntNode(_object.stateEpoch));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            _node.set("startOffset", (JsonNode)new LongNode(_object.startOffset));
            if (_version >= 1) {
                _node.set("deliveryCompleteCount", (JsonNode)new IntNode(_object.deliveryCompleteCount));
            }
            return _node;
        }

        public static JsonNode write(ReadShareGroupStateSummaryResponseData.PartitionResult _object, short _version) {
            return PartitionResultJsonConverter.write(_object, _version, true);
        }
    }
}

